# -*- coding: utf-8 -*-
""" capellaScript -- Matthias Leopold
>>> OrchestrationOptimizer

    Das Programm versucht Instrumentanagaben in Klavierauszügen zu
    erkennen und markiert diese gleichzeitig mit {O:...}
    
    
<<<

History: 03.04.06 - Liedtexte, Akkordsymbole
         
         
"""


from caplib.capDOM import ScoreChange
import os, re, string, sys, tempfile
sys.path.append(os.path.join(getPersonalDataDir(), 'scripts', 'user-scripts'))
import Optimizer, Tools
from Tools import latin1_e
from Tools import latin1_d
from Tools import createNewChild
from Tools import getElement

def debug(text='Text'):
  label = Label(text)
  box = VBox([label],padding=1)
  dlg = Dialog('Debugger', box)
  if dlg.run():
    return True
  else:
    return False



# Prüft, ob es mehr Systeme im Mustersystem gibt, als irgendwann angezeigt werden
# Wenn ja -> Fehlermeldung
def system_check(score):
  global doc  # Referenz auf das Dokument
  doc = score.parentNode
  layout_systems = 0
  max_systems = 0
  for staffLayout in score.getElementsByTagName('staffLayout'):
    layout_systems += 1
  for system in score.getElementsByTagName('system'):
    current_systems = 0
    for staff in system.getElementsByTagName('staff'):
      current_systems += 1
    if current_systems > max_systems:
      max_systems = current_systems
  if max_systems < layout_systems :
    debug('Vermutlich Fehler im Mustersystem!!!')



# Markiere alle Orchestrierungen
def mark_orchestration(score):
  for text in score.getElementsByTagName('text'):
    content = getElement(text, 'content')
    if content.lastChild is None:
      continue;
    ttext = latin1_e(content.lastChild.nodeValue)
    p = re.compile('^[+\\-]|^Viol|^Clar|^Timp|^Va|^Vc|^Ob|^Archi|^Org|^Fag|^Fl|^Cor')
    if p.match(ttext):
      font = getElement(text, 'font')
      q = re.compile('.*1\\.')
      if q.match(ttext):
        font.setAttribute('color', 'FE0000')
      else:
        font.setAttribute('color', 'FE00FE')
      content.lastChild.nodeValue = latin1_d('{O:'+ttext+'}')


# Markiere Instrumentenangaben, die an Pausen stehen
def mark_orchestration_rests(score):
  for rest in score.getElementsByTagName('rest'):
    for text in rest.getElementsByTagName('text'):
      content = getElement(text, 'content')
      if content.lastChild is None:
        continue;
      ttext = latin1_e(content.lastChild.nodeValue)
      p = re.compile('^\\s*\\{[Oo]:')
      if p.match(ttext):
        display = getElement(rest, 'display')
        if not display:
          display = createNewChild(rest, 'display')
        display.setAttribute('color', 'FE0000')



class ScoreChange(ScoreChange):
  def changeScore(self, score):
    Tools.init_doc(score.parentNode)
    Optimizer.repair(score)
    system_check(score)
    Optimizer.de_color(score)
    mark_orchestration(score)
    mark_orchestration_rests(score)
    debug('Ready!')



if activeScore():
  activeScore().registerUndo("CapScan-Fehlersuche")
  tempInput = tempfile.mktemp('.capx')
  tempOutput = tempfile.mktemp('.capx')

  activeScore().write(tempInput)

  ScoreChange(tempInput, tempOutput)
  
  activeScore().read(tempOutput)
  os.remove(tempInput)
  os.remove(tempOutput)

