# -*- coding: utf-8 -*-
""" capellaScript -- Matthias Leopold
>>> MakeBraille
|
Braillenoten erzeugen|
|
(C) Matthias Leopold|
    Deutsche Zentralbücherei für Blinde zu Leipzig|
|
Nutzungsbedingungen:|
|
Der Server darf ausschließlich zu privaten, nicht kommerziellen Zwecken verwendet werden, um Eigenkompositionen, Arrangements, gemeinfreie und andere, nicht urheberrechtlich geschützte Werke umzuwandeln.|
|
Die DZB behält sich vor, die Nutzung des Servers statistisch zu erfassen. Zudem können Stichproben zur Verbesserung der zugrunde liegenden Software oder zur Verhinderung von Missbrauch gegenüber der DZB erfolgen. Alle rechtlichen Gewährleistungen liegen beim Nutzer.|
    
<<<
"""

from caplib.capDOM import ScoreChange
import binascii, os, re, string, tempfile, urllib, urllib2, platform


def dialog(text='Text', title='Debugger'):
  label_w = Label(text)
  box = VBox([label_w], padding=1)
  dlg = Dialog(title, box)
  if dlg.run():
    return True
  else:
    return False

def get_http_data(data={}, file=None):
  #if platform.node().upper() in ['BSH-PURTOV', 'BSH-LEOPOLD', 'BSH-MUELLER', 'BGE-PURTOV', 'BGE-LEOPOLD', 'BGE-MUELLER']:
  # url = 'http://192.168.1.198/MakeBraille/'
  #else:
  url = 'https://makebraille.dzblesen.de/MakeBraille'
  if file != None:
    assert os.path.isfile(file)
    f = open(file, 'rb')
    file_content = f.read()
    file_hex = binascii.hexlify(file_content)
    f.close()
    data['capx'] = file_hex
  encdata = urllib.urlencode(data)
  req = urllib2.Request(url, encdata)
  try:
    response = urllib2.urlopen(req, timeout=600.0)
  except TypeError:
    response = urllib2.urlopen(req)
  try:
    content = response.read()
  except urllib2.HTTPError:
    if 'passwd' in data:
      get_http_data(data={'login' : data['login'], 'passwd' : data['passwd'], 'mode' : 'reset'})
    else:
      get_http_data(data={'clogin' : data['login'], 'mode' : 'reset'})
    content = get_http_data(data=data, file=file)
  return content

makebraille_brl = os.path.join(tempfile.gettempdir(), 'makebraille.brl')
makebraille_login = os.path.join(tempfile.gettempdir(), 'makebraille.login')

def valid_login_text(login):
  if login in ['', None] or login.startswith('<!DOCTYPE') or login.startswith('<html'):
    return False
  return True

  
def get_login_data():
  (login, passwd) = ('', '')
  if os.path.exists(makebraille_login):
    f = open(makebraille_login)
    login = f.readline().strip()
    f.close()
    if valid_login_text(login):
      try:
        encrypted_login = get_http_data(data={'clogin' : login, 'mode' : 'webservice_login'}).strip()
        if encrypted_login != '':
          return encrypted_login
      except urllib2.HTTPError:
        os.remove(makebraille_login)
        return ''
  # not stored yet
  login_l = Label('Login:', width=10)
  login_w = Edit('', width=20)
  passwd_l = Label('Passwort:', width=10)
  passwd_w = Edit('', width=20)
  userinfo = Label('Ich akzeptiere die Nutzungsbedingungen.', width=10)
  box = VBox([login_l, login_w, passwd_l, passwd_w, userinfo],padding=6)
  dlg = Dialog('Login', box)
  if dlg.run():
    login = login_w.value()
    passwd = passwd_w.value()
    if login == '' or passwd == '':
      dialog('Bitte geben Sie Login und Passwort ein.')
      return None
    try:
      encrypted_login = get_http_data(data={'login' : login, 'passwd' : passwd, 'mode' : 'webservice_login'}).strip()
      if valid_login_text(encrypted_login):
        f = open(makebraille_login, 'w')
        f.write(encrypted_login)
        f.close()
        return (encrypted_login)
    except urllib2.HTTPError:
      return ''
  else:
    return None
  return ''


def makebraille(capxfile):
  encrypted_login = get_login_data()
  if encrypted_login == None:
    return
  elif len(encrypted_login):
    html_txt = get_http_data(data={'clogin' : encrypted_login, 'mode' : 'create'}, file=capxfile)
    dialog('Die Noten werden Ihnen in Kürze per Mail zugeschickt', title='Information')
    #f = open(makebraille_brl, 'w')
    #f.write(html_txt)
    #f.close()
    #os.startfile(makebraille_brl)
  else:
    dialog('Login fehlgeschlagen oder abgebrochen', title='Information')

    
class ScoreChange(ScoreChange):
  def changeScore(self, score):
    global doc  # Referenz auf das Dokument
    doc = score.parentNode


if activeScore():
  tempInput = tempfile.mktemp('.capx')
  activeScore().write(tempInput)
  makebraille(tempInput)
  os.remove(tempInput)

