# -*- coding: utf-8 -*-
""" capellaScript -- Matthias Leopold
>>> InvisibleRests
Pausen unsichtbar machen
<<<

History: 03.04.06 - Liedtexte, Akkordsymbole


"""

import xml.dom.minidom
from caplib.rational import Rational
from caplib.capDOM import ScoreChange
import os, re, string, sys, tempfile, zipfile
sys.path.append(os.path.join(getPersonalDataDir(), 'scripts', 'user-scripts'))
import Tools
from Tools import latin1_e
from Tools import latin1_d
from Tools import createNewChild
from Tools import getElement

def debug(text='Text'):
  label = Label(text)
  box = VBox([label],padding=1)
  dlg = Dialog('Debugger', box)
  if dlg.run():
    return True
  else:
    return False

def getCursor():
  sel = curSelection()
  result = None
  if sel == 0:
    messageBox( tr('error'), tr('noActiveScore') )
    return result
  result = sel
  return result


#
# Pausen unsichtbar färben
def invisible_rests(score):
  for rest in score.getElementsByTagName('rest'):
    display = getElement(rest, 'display')
    if not display:
      display = createNewChild(rest, 'display')
    display.setAttribute('invisible', 'true')

files = {}

class ScoreChange(ScoreChange):
  def changeScore(self, score):
    Tools.init_doc(score.parentNode)
    invisible_rests(score)



if activeScore():
  activeScore().registerUndo("CapScan-Fehlersuche")
  tempInput = tempfile.mktemp('.capx')
  tempOutput = tempfile.mktemp('.capx')

  activeScore().write(tempInput)

  ScoreChange(tempInput, tempOutput)

  activeScore().read(tempOutput)
  os.remove(tempInput)
  os.remove(tempOutput)

