# -*- coding: utf-8 -*-

import locale, re, sys
from caplib.capDOM import firstChildElement
import xml.dom.minidom

from Tools import latin1_e
from Tools import latin1_d
from Tools import fromMusicXML

from Tools import createNewChild
from Tools import createNewChildBefore
from Tools import getElement
from Tools import getElements
from Tools import getText
from Tools import isalpha
from Tools import setFont
from Tools import setText
from Tools import stripMarks
from Tools import setAttributes

from Tools import errorColor
from Tools import errorColorI
from Tools import errorColor2
from Tools import errorShape
from Tools import hintColor
from Tools import hintColorI
from Tools import hintColor2
from Tools import commandColor
from Tools import bcColor
from Tools import harmonyColor
from Tools import harmonyColors
from Tools import slurColor

from Tools import commandFont
from Tools import cypherFont
from Tools import lyricsFont
from Tools import bcFont
from Tools import textFont
from Tools import errorFont

messages = []
msgs = {
    'tuplet_rest#german' : 'Rhythmusfehler?',
    'tuplet_rest#english' : 'Rhythm error?',
  }
trnsls = {
    'in_system#german' : ' in System ',
    'in_system#english' : ' in system ',
  }
def add_message(msgcode, system_i=None):
  global messages
  lang = 'english'
  if locale.getdefaultlocale()[0].startswith('de'):
    lang = 'german'
  nmessage = msgs[msgcode+'#'+lang]
  if nmessage not in messages:
    if system_i == None:
      messages.append(nmessage)
    else:
      messages.append(nmessage+trnsls['in_system#'+lang]+str(system_i+1))

# Optimizer wird zum ersten Mal aufgerufen
def first_call(score, types=[]):
  if 'slur' in types:
    for slur in score.getElementsByTagName('slur'):
      if str(slur.getAttribute('color')) in [slurColor, harmonyColor]:
        return False
  if 'command' in types:
    for text in score.getElementsByTagName('text'):
      for content in text.getElementsByTagName('content'):
        if content and content.lastChild != None:
          ttext = latin1_e(content.lastChild.nodeValue)
          if ttext.startswith('{') and ttext.endswith('}'):
            font = getElement(text, 'font')
            if font and font.getAttribute('face') == commandFont and \
               font.getAttribute('height') == '9' and \
               font.getAttribute('charSet') == '1':
              return False
  for keywords in score.getElementsByTagName('keywords'):
    if 'Optimizer' in latin1_e(keywords.lastChild.nodeValue):
      return False
  return True

# Lösche leere content-Knoten
# utf-8 Optimierung
def repair(score):
  for drawObjects in score.getElementsByTagName('drawObjects'):
    for drawObj in drawObjects.getElementsByTagName('drawObj'):
      for content in drawObj.getElementsByTagName('content'):
        if not content.hasChildNodes():
           drawObjects.removeChild(drawObj)


def repair_brackets(score):
  # falsche Voltenklammern löschen
  for brackets in score.getElementsByTagName('brackets'):
    for bracket in brackets.getElementsByTagName('bracket'):
      b_from = int(latin1_e(bracket.getAttribute('from')))
      b_to = int(latin1_e(bracket.getAttribute('to')))
      if b_from == b_to:
        brackets.removeChild(bracket)
  # ersetzte geschweifte systemklammern durch eckige
  for layout in score.getElementsByTagName('layout'):
    for bracket in layout.getElementsByTagName('bracket'):
      if bracket.getAttribute('from') == '0' and bracket.getAttribute('to') == '1': # and bracket.getAttribute('curly') == 'true':
        # falls in beiden systemen lyric stehen
        for system in score.getElementsByTagName('systems'):
          staffs = system.getElementsByTagName('staff')
          if len(staffs) >= 2:
            lyrics1 = staffs[0].getElementsByTagName('lyric')
            lyrics2 = staffs[1].getElementsByTagName('lyric')
            if len(lyrics1) > 5 and len(lyrics2) > 5:
              bracket.setAttribute('curly', 'false')
              return
        # falls in beiden Systemen Instrumentnamen stehen
        staffLayouts = layout.getElementsByTagName('staffLayout')
        if len(staffLayouts) > 1 and len(staffLayouts[0].getElementsByTagName('instrument')) and \
           len(staffLayouts[1].getElementsByTagName('instrument')):
          instruments = staffLayouts[0].getElementsByTagName('instrument')+staffLayouts[1].getElementsByTagName('instrument')
          if instruments[0].getAttribute('name').strip() != '' and instruments[1].getAttribute('name').strip() != '':
            bracket.setAttribute('curly', 'false')
            instruments[0].setAttribute('pairName', '')
            instruments[1].setAttribute('pairName', '')
            for pairName in layout.getElementsByTagName('pairName'):
              pairName.lastChild.nodeValue = ''
            # TODO löschen Element pairname if existent in beiden
            return
      
# Entfärbe die Noten/Bögen/Akkorde usw.
def de_color(score):
  noteColors = [errorColor2, errorColor, '7F0000', hintColor, '0000FE', slurColor, '555522', '222266', commandColor]
  restColors = [errorColor, errorColorI, '555522', '222266', hintColor, hintColorI, hintColor2]
  slurColors = [errorColor, hintColor, slurColor, harmonyColor]
  for chord in score.getElementsByTagName('chord'):
    display = getElement(chord, 'display')
    if display and display.getAttribute('color') in noteColors:
      if display.getAttribute('color') in [errorColor, errorColor2]:
        for head in chord.getElementsByTagName('head'):
          if head.getAttribute('shape') == errorShape:
            head.setAttribute('shape', 'normal')
      display.setAttribute('color', '000000')
  for rest in score.getElementsByTagName('rest'):
    display = getElement(rest, 'display')
    if display and display.getAttribute('color') in [errorColorI, hintColorI]:
      display.setAttribute('invisible', 'true')
    if display and display.getAttribute('color') in restColors:
      display.setAttribute('color', '000000')
  for slur in score.getElementsByTagName('slur'):
    if slur.getAttribute('color') in slurColors:
      slur.setAttribute('color', '000000')
  for volta in score.getElementsByTagName('volta'):
    if volta.getAttribute('color') == errorColor:
      volta.setAttribute('color', '000000')
  for timeSign in score.getElementsByTagName('timeSign'):
    if timeSign.getAttribute('color') == errorColor:
      timeSign.setAttribute('color', '000000')
  for keySign in score.getElementsByTagName('keySign'):
    if keySign.getAttribute('color') == errorColor:
      keySign.setAttribute('color', '000000')
  for barline in score.getElementsByTagName('barline'):
    if barline.getAttribute('color') == errorColor:
      barline.setAttribute('color', '000000')
  for wedge in score.getElementsByTagName('wedge'):
    if wedge.getAttribute('color') in [errorColor, hintColor, '555522']:
      wedge.setAttribute('color', '000000')
  for rectangle in score.getElementsByTagName('rectangle'):
    if rectangle.getAttribute('color') in [errorColor, hintColor]:
      rectangle.setAttribute('color', '000000')
  for font in score.getElementsByTagName('font'):
    if font.getAttribute('color') in [errorColor, errorColor2, hintColor , hintColor2, '0000FE', slurColor, commandColor, '808000', '555522']: #slur.getAttribute('color') == 'FF0000' or
      if font.getAttribute('color') in [errorColor, errorColor2]:
        font.setAttribute('underline', 'false')
      font.setAttribute('color', '000000')
    if font.getAttribute('color') in harmonyColors:
      font.setAttribute('color', harmonyColor)
  dollar_number_regex = re.compile('^\$\d+$')
  for text in score.getElementsByTagName('text'):
    for font in text.getElementsByTagName('font'):
      if font.getAttribute('face') == commandFont:
        for content in text.getElementsByTagName('content'):
          dtext = latin1_e(content.lastChild.nodeValue)
          if dollar_number_regex.match(dtext):
            content.lastChild.nodeValue = ''

# Wandelt rtf-Texte in einfache Texte um
from caplib import Rtf2Txt
def rtf_to_texts(score, files):
  doc = score.parentNode
  r = re.compile(r'\{|\}|\\\w+|Arial;|capella3;|Times New Roman;|Segoe UI;')
  a = chr(13)
  t = re.compile(a, re.MULTILINE)
  u = re.compile('^'+a+'+')
  v = re.compile(a+'+$')
  w = re.compile(r'^\s*', re.MULTILINE)
  x = re.compile(r'\s*$', re.MULTILINE)
  y = re.compile(r' +')
  for event_type in ['chord', 'rest']:
    for event in score.getElementsByTagName(event_type):
      for drawObj in event.getElementsByTagName('drawObj'):
        transposable = getElement(drawObj, 'transposable')
        if not transposable:
          rtf = getElement(drawObj, 'richText')
          # sonst prüfen ob RTF-Dateien vorliegen und diese entsprechend auswerten
          if rtf:
            rtf_file = latin1_e(rtf.getAttribute('file'))
            rtf_text = files[rtf_file]
            rtf_text_dummy = Rtf2Txt.getTxt(rtf_text)
            if '?' not in rtf_text_dummy:
              rtf_text = rtf_text_dummy
            # Metronomangaben nicht anfassen
            if re.match(r'(\(|\[|)\?\.?\s*=', rtf_text_dummy):
              continue
            if re.match(r'(\(|\[|)[¢]\.?\s*=', rtf_text):
              continue
            #if 'Dal' in rtf_text:
            #  assert False, rtf_text
            #if 'Dal' in rtf_text:
            #  assert False, rtf_text
            #if 'capella3' in rtf_text:
            #  continue
            italic = 'false'
            if rtf_text.find('\\i\\') > -1 or rtf_text.find('\\i ') > -1:
              italic = 'true'

            rtf_text = rtf_text.replace('\\{', '###BRACKETOPEN###')
            rtf_text = rtf_text.replace('\\}', '###BRACKETCLOSE###')
            rtf_text = rtf_text.replace('\\\\', '###BACKSLASH###')
            # capella symbols
            rtf_text = rtf_text.replace(r'\u196?', 'Ä')
            rtf_text = rtf_text.replace(r'\u214?', 'Ö')
            rtf_text = rtf_text.replace(r'\u220?', 'Ü')
            rtf_text = rtf_text.replace(r'\u228?', 'ä')
            rtf_text = rtf_text.replace(r'\u246?', 'ö')
            rtf_text = rtf_text.replace(r'\u252?', 'ü')
            rtf_text = rtf_text.replace(r'\u223?', 'ß')
            rtf_text = rtf_text.replace(r'\u233?', 'é')
            rtf_text = rtf_text.replace(r'\u61550?', '#[#0l#]#')
            rtf_text = rtf_text.replace(r'\u61551?', '#[#0l#]#')
            rtf_text = rtf_text.replace(r'\u61561?', '#[#0#]#')
            rtf_text = rtf_text.replace(r'\u61472?', ' ')
            rtf_text = rtf_text.replace(r'\u61485?', '-')
            rtf_text = r.sub('', rtf_text)
            rtf_text = rtf_text.replace('###BRACKETOPEN###', '{')
            rtf_text = rtf_text.replace('###BRACKETCLOSE###', '}')
            rtf_text = rtf_text.replace('###BACKSLASH###', '\\')
            # Carriage return löschen
            rtf_text = t.sub('', rtf_text)
            # Führende und endende Zeilenumbrüche löschen
            a = chr(10)
            rtf_text = u.sub('', rtf_text)
            rtf_text = v.sub('', rtf_text)
            # Führende und endende Leerzeichen entfernen
            rtf_text = w.sub('', rtf_text)
            rtf_text = x.sub('', rtf_text)
            rtf_text = y.sub(' ', rtf_text)
            rtf_text = rtf_text.replace("\\'e4", 'ä')
            rtf_text = rtf_text.replace("\\'f6", 'ö')
            rtf_text = rtf_text.replace("\\'fc", 'ü')
            rtf_text = rtf_text.replace("\\'c4", 'Ä')
            rtf_text = rtf_text.replace("\\'d6", 'Ö')
            rtf_text = rtf_text.replace("\\'dc", 'Ü')
            rtf_text = rtf_text.replace("\\'df", 'ß')
            rtf_text = rtf_text.replace("\\'e1", 'á')
            rtf_text = rtf_text.replace("\\'e0", 'à')
            rtf_text = rtf_text.replace("\\'e2", 'â')
            rtf_text = rtf_text.replace("\\'e9", 'é')
            rtf_text = rtf_text.replace("\\'e8", 'è')
            rtf_text = rtf_text.replace("\\'ea", 'ê')
            rtf_text = rtf_text.replace("\\'ed", 'í')
            rtf_text = rtf_text.replace("\\'ec", 'ì')
            rtf_text = rtf_text.replace("\\'ee", 'î')
            rtf_text = rtf_text.replace("\\'f3", 'ó')
            rtf_text = rtf_text.replace("\\'f2", 'ò')
            rtf_text = rtf_text.replace("\\'f4", 'ô')
            rtf_text = rtf_text.replace("\\'fa", 'ú')
            rtf_text = rtf_text.replace("\\'f9", 'ù')
            rtf_text = rtf_text.replace("\\'fb", 'û')
            rtf_text = rtf_text.replace("\\'c1", 'Á')
            rtf_text = rtf_text.replace("\\'c0", 'À')
            rtf_text = rtf_text.replace("\\'c2", 'Â')
            rtf_text = rtf_text.replace("\\'c9", 'É')
            rtf_text = rtf_text.replace("\\'c8", 'È')
            rtf_text = rtf_text.replace("\\'ca", 'Ê')
            rtf_text = rtf_text.replace("\\'cd", 'Í')
            rtf_text = rtf_text.replace("\\'cc", 'Ì')
            rtf_text = rtf_text.replace("\\'ce", 'Î')
            rtf_text = rtf_text.replace("\\'d3", 'Ó')
            rtf_text = rtf_text.replace("\\'d2", 'Ò')
            rtf_text = rtf_text.replace("\\'d4", 'Ô')
            rtf_text = rtf_text.replace("\\'da", 'Ú')
            rtf_text = rtf_text.replace("\\'d9", 'Ù')
            rtf_text = rtf_text.replace("\\'db", 'Û')
            rtf_text = rtf_text.replace("\\'a9", '©')
            rtf_text = rtf_text.replace("\\'ae", '®')
            rtf_text = rtf_text.replace("\\'9f", 'Ÿ')
            rtf_text = rtf_text.replace("\\'ff", 'ÿ')
            rtf_text = rtf_text.replace("\\'8c", 'Œ')
            rtf_text = rtf_text.replace("\\'9c", 'œ')
            rtf_text = rtf_text.replace("\\'d1", 'Ñ')
            rtf_text = rtf_text.replace("\\'f1", 'ñ')
            rtf_text = rtf_text.replace("\\'cb", 'Ë')
            rtf_text = rtf_text.replace("\\'eb", 'ë')
            rtf_text = rtf_text.replace("\\'d8", 'Ø')
            rtf_text = rtf_text.replace("\\'f8", 'ø')
            rtf_text = rtf_text.replace("\\'c6", 'Æ')
            rtf_text = rtf_text.replace("\\'e6", 'æ')
            rtf_text = rtf_text.replace("\\'c5", 'Å')
            rtf_text = rtf_text.replace("\\'e5", 'å')
            rtf_text = rtf_text.replace("\\'c7", 'Ç')
            rtf_text = rtf_text.replace("\\'e7", 'ç')
            rtf_text = rtf_text.replace("\\'cf", 'Ï')
            rtf_text = rtf_text.replace("\\'ef", 'ï')
            # Postparate [ => { etc.
            rtf_text = rtf_text.replace('#[#', '{')
            rtf_text = rtf_text.replace('#]#', '}')
            xx = str(float(latin1_e(rtf.getAttribute('x')))-0.22)
            yy = str(float(latin1_e(rtf.getAttribute('y')))+2.56)
            drawObj.removeChild(rtf)
            for basic in drawObj.getElementsByTagName('basic'):
              drawObj.removeChild(basic)
            text = createNewChild(drawObj, 'text', attrib={'x':xx, 'y':yy})
            font = createNewChild(text, 'font')
            setFont(font, italic=italic)
            font.setAttribute('height', '12')
            font.setAttribute('face', textFont)
            content = createNewChild(text, 'content')
            content.appendChild(doc.createTextNode(latin1_d(rtf_text)))

shortcut_subs = [('c:', 'CREATOR'), ('d:', 'DIR'),
                 ('t:', 'TITLE'), ('s:', 'SOURCE'),
                 ('l:', 'LCAPTION'), ('st:', 'STITLE'),
                 ('p:', 'P'),
                 ]

def shortcut_commands(score):
  for text in score.getElementsByTagName('text'):
    for content in text.getElementsByTagName('content'):
      dtext = latin1_e(content.lastChild.nodeValue)
      for (shortcut, subs) in shortcut_subs:
        if dtext.startswith(shortcut):
          content.lastChild.nodeValue = latin1_d('{'+subs+dtext[len(shortcut)-1:].strip()+'}')
          break      

###############################################################################

_special_words = ['m.s.', 'm. s.' 'ms', 'm.g.', 'm. g.', 'mg', 'L.H', 'L.H.', 'L. H.', 'LH', 'm. d.', 'm.d.', 'md', 'R.H', 'R.H.', 'R. H.', 'RH']
def special_words(score):
  for text in score.getElementsByTagName('text'):
    for content in text.getElementsByTagName('content'):
      dtext = latin1_e(content.lastChild.nodeValue)
      if dtext in _special_words+[sw.lower() for sw in _special_words]:
        dtext = dtext.replace(' ', '')
        content.lastChild.nodeValue = latin1_d(dtext)
        font = createNewChild(text, 'font')
        setFont(font)
        font.setAttribute('color', errorColor)
        font.setAttribute('height', '12')
        font.setAttribute('face', 'Verdana')
        font.setAttribute('italic', 'true')
      

###############################################################################

bc_like_regex = re.compile(r'[\d#\+]b?|^b$')

def _count_upper_lower_bc_like(staff):
  upper_c = 0
  lower_c = 0
  finger_c = 1
  for text in staff.getElementsByTagName('text'):
    for content in text.getElementsByTagName('content'):
      dtext = latin1_e(content.lastChild.nodeValue)
      lines = dtext.split('\n')
      for line in lines:
        if bc_like_regex.search(line):
          y = float(text.getAttribute('y'))
          if y < 0:
            upper_c += 1
          else:
            lower_c += 1
        if line in list('012345'):
          finger_c += 1
  return upper_c, lower_c, finger_c

# Erkenne Texte als basso continuo und wandele diese in lyric um
def basso_continuo_to_lyrics(score):
  if not first_call(score):
    return
  fb_like_text_count = 0
  other_text_count = 0
  finger_text_count = 0
  for system in score.getElementsByTagName('system'):
    staffs = system.getElementsByTagName('staff')
    for staff in staffs[:-1]:
      upper_c, lower_c, finger_c = _count_upper_lower_bc_like(staff)
      finger_text_count += finger_c
      other_text_count += lower_c + upper_c
    upper_c, lower_c, finger_c = _count_upper_lower_bc_like(staffs[-1])
    finger_text_count += finger_c
    other_text_count += upper_c
    fb_like_text_count += lower_c
  # 19/4/12 13:54
  if finger_text_count >= fb_like_text_count:
    return
  if fb_like_text_count > 30 and other_text_count < 5:
    assert False, str(fb_like_text_count)+'  '+str(other_text_count)
    for system in score.getElementsByTagName('system'):
      staffs = system.getElementsByTagName('staff')
      for chord in staffs[-1].getElementsByTagName('chord'):
        lyric = getElement(chord, 'lyric')
        if not lyric:
          lyric_i = 0
          lyric = createNewChild(chord, 'lyric')
          verse = None
          for drawObj in chord.getElementsByTagName('drawObj'):
            for text in drawObj.getElementsByTagName('text'):
              x = text.getAttribute('x')
              for content in text.getElementsByTagName('content'):
                dtext = getText(content).strip()
                if bc_like_regex.search(dtext):
                  lines = dtext.strip().split('\n')
                  for line in lines:
                    if verse != None and float(x) > 1.5:
                      setText(verse, getText(verse)+'_'+line)
                    else:
                      verse = createNewChild(lyric, 'verse', new=True, attrib={'i':str(lyric_i), 'align':'left', 'extentControl':'true'})
                      line = line.replace('f', '+').replace('N', 'n').replace('M', 'n')
                      setText(verse, line)
                      lyric_i += 1
                  drawObj.removeChild(text)
      for rest in staffs[-1].getElementsByTagName('rest'):
        for content in rest.getElementsByTagName('content'):
          dtext = getText(content).strip()
          if bc_like_regex.search(dtext) and '{' not in dtext:
            setText(content, '{BC:'+dtext+'}')
            

###############################################################################

# Liedtexte blau färben
# Bezifferte Bässe rostbraun färben
def blue_lyrics(score):
  p = re.compile('[a-zA-Zäöüæåàâèéêëîïôøœùûß]')
  q = re.compile('[0-9bn]')
  r = re.compile('[0-5]')
  for voices in score.getElementsByTagName('voices'):
    voicenr = 0
    for voice in voices.getElementsByTagName('voice'):
      voicenr += 1
      basso_continuo = 1 # 0 => es handelt sich um Liedtexte
      all_text = ''
      for verse in voice.getElementsByTagName('verse'):
        all_text += getText(verse)
      ptext = p.sub('', all_text)
      qtext = q.sub('', all_text)
      rtext = r.sub('', all_text)
      if len(rtext) == 0 or len(ptext) < len(qtext):
        basso_continuo = 0
      # In jeder Zeile die Liedtexte so weit unten wie möglich ausrichten => max_verse_count ist Anzahl der parallelen Liedzeilen in der aktuellen Stimme
      max_verse_count = 0
      for chord in voice.getElementsByTagName('chord'):
        current_verse_count = 0
        for verse in chord.getElementsByTagName('verse'):
          current_verse_count += 1
        if current_verse_count > max_verse_count:
          max_verse_count = current_verse_count
      for lyricsSettings in voice.getElementsByTagName('lyricsSettings'):
        if not first_call(score):
          pass
        elif float(latin1_e(lyricsSettings.getAttribute('firstLine'))) >= 0:
          if voicenr > 1:
            lyricsSettings.setAttribute('firstLine', '6')
          else:
            lyricsSettings.setAttribute('firstLine', '5.5')
        else:
          if voicenr > 1:
            lyricsSettings.setAttribute('firstLine', str(-3-max_verse_count*2.5))
          else:
            lyricsSettings.setAttribute('firstLine', str(-3.5-max_verse_count*2.5))
        if first_call(score):
          lyricsSettings.setAttribute('firstLine', str(float(lyricsSettings.getAttribute('firstLine'))+1.0))
          lyricsSettings.setAttribute('lineDist', '2.5')
        for font in lyricsSettings.getElementsByTagName('font'):
          setFont(font)
          if basso_continuo:
            font.setAttribute('color', bcColor)
            font.setAttribute('face', bcFont)
            font.setAttribute('charSet', '1')
          else:
            if voicenr > 1:
              font.setAttribute('color', '800080')
            else:
              font.setAttribute('color', '0000FE')
            font.setAttribute('face', lyricsFont)
          if first_call(score):
            font.setAttribute('height', '11')
            font.setAttribute('pitchAndFamily', '2')
      if basso_continuo == 0:
        for verse in voice.getElementsByTagName('verse'):
          if verse != None and getText(verse) == '7':
            setText(verse, 'x')

# Akkordsymbole grün färben
def green_chords(score):
  def _looks_like_chord(font, text):
    return font.getAttribute('underline') == 'true' and \
           text in list('ABCDEFGH')
  for chord_rest in ['chord', 'rest']:
    for event in score.getElementsByTagName(chord_rest):
      for transposable in event.getElementsByTagName('transposable'):
        for font in transposable.getElementsByTagName('font'):
          setFont(font, type='chord')
        if event.nodeName != 'rest' or getElement(event, 'duration').getAttribute('base') != '1':
          for text in transposable.getElementsByTagName('text'):
            text.setAttribute('x', '0.0')
  p = re.compile('^\s*\{\s*[Cc][Hh]?[Oo][Rr][Dd]\s*:\s*(.*?)\s*\}\s*$')
  q = re.compile(' +')
  for text in score.getElementsByTagName('text'):
    font = getElement(text, 'font')
    if not font or not font.getAttribute('face') == 'capella3':
      content = getElement(text, 'content')
      if content.lastChild is None:
        continue
      dtext = latin1_e(content.lastChild.nodeValue)
      if p.match(dtext) or font.getAttribute('color') == harmonyColor or \
         _looks_like_chord(font, dtext):
        setFont(font, type='chord')
        #text.setAttribute('x', '0.0')
        dtext = p.sub(r'\1', dtext)
        dtext = q.sub(r'', dtext)
        content.lastChild.nodeValue = latin1_d(dtext)
  for text in score.getElementsByTagName('text'):
    font = getElement(text, 'font')
    

# #####
def optimize_chords(score, files):
  chords_to_texts(score, files)
  chord_texts_normalize(score)
  join_chords(score)

# Wandelt Akkordsymbole (Textartige und RTF-s) in gefärbte einfache Texte um
def chords_to_texts(score, files):
  doc = score.parentNode
  r = re.compile(r'\{|\}|\\\w+|\s+|Arial;|capella3;|Times New Roman;')
  for event_type in ['chord', 'rest']:
    for event in score.getElementsByTagName(event_type):
      for drawObj in event.getElementsByTagName('drawObj'):
        transposable = getElement(drawObj, 'transposable')
        if transposable:
          # Basis des Akkordes festellen (verweist auf den richtiogen Eintrag in der Akkordliste)
          base = latin1_e(transposable.getAttribute('base'))
          chord_text = transposable.getAttribute('base')
          # Nun in tr_drawObj das zugehörige Akkordobjeklt feststellen
          for tr_drawObj in transposable.getElementsByTagName('drawObj'):
            if base == latin1_e(tr_drawObj.getAttribute('base')):
              chord_text = ''
              for content in tr_drawObj.getElementsByTagName('content'):
                if content.lastChild is None:
                  continue
                chord_text += latin1_e(content.lastChild.nodeValue)
              break
            tr_drawObj = 0
          if tr_drawObj:
            text = getElement(tr_drawObj, 'text')
            # Wenn es sich um ein Textobjekt handelt, so dieses einfach an Stelle der Akkorde setzen
            if text:
              old_x = text.getAttribute('x')
              y = text.getAttribute('y')
              drawObj.removeChild(transposable)
              for basic in drawObj.getElementsByTagName('basic'):
                drawObj.removeChild(basic)
              text = createNewChild(drawObj, 'text')
              # nicht auf 0 setzten bei Ganztaktpausen
              if event.nodeName != 'rest' or getElement(event, 'duration').getAttribute('base') != '1':
                text.setAttribute('x', '0.0')
              else:
                text.setAttribute('x', old_x)
              text.setAttribute('y', y)
              font = createNewChild(text, 'font')
              setFont(font)
              font.setAttribute('color', harmonyColor)
              font.setAttribute('height', '12')
              font.setAttribute('face', 'Verdana')
              font.setAttribute('underline', 'true')
              for repl in ['tt','tf','￼','ￖ','»','«','Jt','tl','li''it']:
                chord_text = chord_text.replace(repl,'#')
              chord_text = chord_text.replace('t', 'b').replace('°', 'o').replace('SUS', 'sus').replace('rn','m')
              content = createNewChild(text, 'content')
              content.appendChild(doc.createTextNode(latin1_d(chord_text)))
            else:
              rtf = getElement(tr_drawObj, 'richText')
              # sonst prüfen ob RTF-Dateien vorliegen und diese entsprechend auswerten
              if rtf:
                rtf_file = latin1_e(rtf.getAttribute('file'))
                y = rtf.getAttribute('y')
                rtf_text = files[rtf_file]
                rtf_text = r.sub('', rtf_text)
                rtf_text = rtf_text.replace('P', 'bb').replace('Q', 'b').replace('R', 'n').replace('SUS','sus').replace('S', '#')
                rtf_text = rtf_text.replace('T', '##').replace('tt', '#').replace('t', 'b').replace('\\\'b0', 'o')
                drawObj.removeChild(transposable)
                for basic in drawObj.getElementsByTagName('basic'):
                  drawObj.removeChild(basic)
                text = createNewChild(drawObj, 'text', attrib={'x':'0.0', 'y':y})
                font = createNewChild(text, 'font')
                setFont(font)
                font.setAttribute('color', harmonyColor)
                font.setAttribute('height', '12')
                font.setAttribute('face', 'Verdana')
                font.setAttribute('underline', 'true')
                content = createNewChild(text, 'content')
                content.appendChild(doc.createTextNode(latin1_d(rtf_text)))
              else:
                y = '-4.0'
                for text in tr_drawObj.getElementsByTagName('text'):
                  y = text.getAttribute('y')
                  break
                drawObj.removeChild(transposable)
                for basic in drawObj.getElementsByTagName('basic'):
                  drawObj.removeChild(basic)
                text = createNewChild(drawObj, 'text', attrib={'x':'0.0', 'y':y})
                font = createNewChild(text, 'font')
                setFont(font)
                font.setAttribute('color', harmonyColor)
                font.setAttribute('height', '12')
                font.setAttribute('face', 'Verdana')
                font.setAttribute('underline', 'true')
                chord_text = chord_text.replace('P', 'bb').replace('Q', 'b').replace('R', 'n').replace('SUS','sus').replace('S', '#')
                chord_text = chord_text.replace('T', '##').replace('tt', '#').replace('\\\'b0', 'o')
                chord_text = chord_text.replace('SUS','sus')
                content = createNewChild(text, 'content')
                content.appendChild(doc.createTextNode(latin1_d(chord_text)))

def chord_texts_normalize(score):
  for event_type in ['chord', 'rest']:
    for event in score.getElementsByTagName(event_type):
      for drawObj in event.getElementsByTagName('drawObj'): 
        text = getElement(drawObj, 'text')
        if text:
          font = getElement(text, 'font')
          if font and font.getAttribute('color') in harmonyColors:
            # assert False, 'dkflkdjfl'
            content = getElement(text, 'content')
            if content and content.lastChild.nodeValue:
              content.lastChild.nodeValue = content.lastChild.nodeValue.replace('SUS','sus')

def _looks_like_chord(font):
  return font.getAttribute('underline') == 'true' and \
         font.getAttribute('color') in harmonyColors+[hintColor]

# A + (C) => A(C)
# A#7 G#7 => A#7_G#7
def join_chords(score):
  for drawObjects in score.getElementsByTagName('drawObjects'):
    drawObjs = drawObjects.getElementsByTagName('drawObj')
    if len(drawObjs) == 2:
      [drawObj1, drawObj2] = drawObjs
      text1 = getElement(drawObj1, 'text')
      text2 = getElement(drawObj2, 'text')
      if text1 and text2:
        x1 = float(text1.getAttribute('x'))
        x2 = float(text2.getAttribute('x'))
        content1 = getElement(text1, 'content')
        content2 = getElement(text2, 'content')
        font1 = getElement(text1, 'font')
        font2 = getElement(text2, 'font')
        ttext1 = content1.lastChild.nodeValue
        ttext2 = content2.lastChild.nodeValue
        if font1 and font2 and _looks_like_chord(font1) and _looks_like_chord(font2):
          if not ttext1.startswith('(') and ttext2.startswith('('):
            content1.lastChild.nodeValue += ttext2
            drawObjects.removeChild(drawObj2)
          elif ttext1.startswith('(') and not ttext2.startswith('('):
            content2.lastChild.nodeValue += ttext1
            drawObjects.removeChild(drawObj1)
          elif x1 < x2:
            content1.lastChild.nodeValue += '_'+ttext2
            drawObjects.removeChild(drawObj2)
          else:
            content2.lastChild.nodeValue += '_'+ttext1
            drawObjects.removeChild(drawObj1)

# Einzelklammern um Systeme entfernen
# helper
def set_chord_rest_color(chord_rest, color):
  # these colors indicate voices etc.
  #reserved = ['008080', '40CCFF', '000080', '808000', '800080']+harmonyColors
  display = getElement(chord_rest, 'display')
  if not display:
    display = createNewChild(chord_rest, 'display')
  if not display.hasAttribute('color') or display.getAttribute('color') in ['000000', hintColor, hintColor2]:
    display.setAttribute('color', color)
    if color in [errorColor, errorColor2]:
      display.setAttribute('color', errorColor)
      for head in chord_rest.getElementsByTagName('head'):
        head.setAttribute('shape', errorShape)


# Noten rot färben, bei denen eine Silbe mit einem \- - Bindestrich endet/beginnt
def minus_verses(score):
  #r = re.compile(r'^\s*-+')
  #s = re.compile(r'-+\s*$')
  #t = re.compile('^[1-9A-Za-zÄÖÜÆÅÀÂÈÉÊËÎÏÔØŒÙÛäöüæåàâèéêëîïôøœùûß\\-.,;:?!]+$')
  for voice in score.getElementsByTagName('voice'):
    if is_basso_continuo(voice):
      continue
    for chord in voice.getElementsByTagName('chord'):
      for verse in chord.getElementsByTagName('verse'):
        text = getText(verse)
        # Bindestriche vor hyphen löschen
        while len(text) and text[-1] == '-' and verse.getAttribute('hyphen') == 'true':
          setText(verse, text[:-1])
          text = getText(verse)
        if text == "'-":
          continue
        if fromMusicXML(score) and len(text) and text[-1] == '-':
          verse.setAttribute('hyphen', 'true')
          setText(verse, text[:-1])
          text = getText(verse)
        if len(text) and (text[0] == '-' or text[-1] == '-'):
          set_chord_rest_color(chord, errorColor)

# Färbung falls ohne Silbenbindeng '-' folgt
def non_bind(score):
  for voice in score.getElementsByTagName('voice'):
    chord = voice.getElementsByTagName('chord')
    for chord_i in range(chord.length-1):
      verses1 = chord[chord_i].getElementsByTagName('verse')
      verses2 = chord[chord_i+1].getElementsByTagName('verse')
      for verse_i, verse1 in enumerate(verses1):
        if verse_i < len(verses2):
          verse2 = verses2[verse_i]
          # Text auf verse1, Silbenbindung auf verse2 => Warnung
          if verse1.hasChildNodes() and verse1.getAttribute('hyphen') != 'true' and \
             not verse2.hasChildNodes() and verse2.getAttribute('hyphen') == 'true':
            set_chord_rest_color(chord[chord_i], errorColor)
  # Löschen der Silbenbindung, falls kein Text steht
  for verse in score.getElementsByTagName('verse'):
    if getText(verse) == '':
      verse.setAttribute('hyphen', 'false')
  # falls Satzzeichen steht und Silbenbindung, so rot färben
  s = re.compile(r'[,;.:!?]')
  for chord in score.getElementsByTagName('chord'):
    for verse in chord.getElementsByTagName('verse'):
      text = getText(verse)
      if text != '':
        if s.search(text) and verse.getAttribute('hyphen') == 'true':
          set_chord_rest_color(chord, errorColor)

# Doppelsilbe an Note vor Note ohne Silbe
def non_splitted(score):
  two_vowels_regex = re.compile('^.*?[aeiouäöü].+[aeiouäöü]')
  for system in score.getElementsByTagName('system'):
    chords = system.getElementsByTagName('chord')
    i = 0
    while i < len(chords)-1:
      chord1 = chords[i]
      chord2 = chords[i+1]
      if chord2.getElementsByTagName('verse') == []:
        for verse in chord1.getElementsByTagName('verse'):
          if two_vowels_regex.match(getText(verse)):
            set_chord_rest_color(chord1, slurColor)
      i += 1

# Kleingedruckte Noten rostbraun färben
def pink_cues(score):
  for chord in score.getElementsByTagName('chord'):
    for display in chord.getElementsByTagName('display'):
      for duration in chord.getElementsByTagName('duration'):
        if display.getAttribute('small') == 'true' and duration.getAttribute('noDuration') != 'true':
          set_chord_rest_color(chord, hintColor2)
  for rest in score.getElementsByTagName('rest'):
    for display in rest.getElementsByTagName('display'):
      for duration in rest.getElementsByTagName('duration'):
        if display.getAttribute('small') == 'true' and duration.getAttribute('noDuration') != 'true':
          set_chord_rest_color(rest, hintColor2)

# Noten ohne Länge mit normaler Größe rostbraun färben
#TODO not linked
def normal_sized_graces(score):
  for chord in score.getElementsByTagName('chord'):
    for duration in chord.getElementsByTagName('duration'):
      if duration.getAttribute('noDuration') == 'true':
        display = getElement(chord, 'display')
        if display and display.getAttribute('small') == 'true':
          continue
        set_chord_rest_color(chord, hintColor2)
  for rest in score.getElementsByTagName('rest'):
    for duration in rest.getElementsByTagName('duration'):
      if duration.getAttribute('noDuration') == 'true':
        display = getElement(rest, 'display')
        if display and display.getAttribute('small') == 'true':
          continue
        set_chord_rest_color(rest, hintColor2)

# seltenere grace-Typen werden eingefärbt um mögliche Scanfehler aufzuzeigen
# Beispiel: 32tel graces werden eingefärbt wenn die meisten graces 16tel sind
def rare_type_graces(score):
  types = {}
  for chord in score.getElementsByTagName('chord'):
    for duration in chord.getElementsByTagName('duration'):
      if duration.getAttribute('noDuration') == 'true':
        for display in chord.getElementsByTagName('display'):
          if display.getAttribute('small') == 'true':
            base = duration.getAttribute('base')
            if base in types:
              types[base] += 1
            else:
              types[base] = 1
  if len(types) > 1:
    if sys.version_info >= (2,5):
      most_frequent_type = sorted(types, key=types.get, reverse=True)[0]
    else:
      most_frequent_type = None
    for chord in score.getElementsByTagName('chord'):
      for duration in chord.getElementsByTagName('duration'):
        if duration.getAttribute('noDuration') == 'true':
          for display in chord.getElementsByTagName('display'):
            if display.getAttribute('small') == 'true':
              if duration.getAttribute('base') != most_frequent_type:
                set_chord_rest_color(chord, hintColor)

# Nachschläge pink färben (nur zur Anzeige)
def pink_post_graces(score):
  for chord in score.getElementsByTagName('chord'):
    for duration in chord.getElementsByTagName('duration'):
      if duration.getAttribute('noDuration') == 'true':
        for display in chord.getElementsByTagName('display'):
          display.setAttribute('xShift', '0')
          if display.getAttribute('postGrace') == 'true':
            set_chord_rest_color(chord, hintColor)

# Pedalsternchen rot färben, sofoern deutlich links von Notenkopf
# Zentrieren wenn horizontal nah bei Note
def mark_pedal(score):
  for text in score.getElementsByTagName('text'):
    font = getElement(text, 'font')
    if font and font.getAttribute('face') == 'capella3':
      content = getElement(text, 'content')
      if content.lastChild != None:
        dtext = latin1_e(content.lastChild.nodeValue)
        if dtext == 'b' and float(text.getAttribute('x')) < -1.0:
          font.setAttribute('color', errorColor)
        if dtext == 'b' and abs(float(text.getAttribute('x'))) < 0.35:
          text.setAttribute('x', '0.0')
    if font:
      content = getElement(text, 'content')
      if content.lastChild != None:
        dtext = latin1_e(content.lastChild.nodeValue)
        if dtext in ['Ped.', 'Ped', 'ped.', 'ped']:
          font.setAttribute('color', errorColor)


# Bögen färben, die getrennt und doch eigentlich eins sind
def slurs(score):
  for staff in score.getElementsByTagName('staff'):
    for voice in staff.getElementsByTagName('voice'):
      for noteObjects in voice.getElementsByTagName('noteObjects'):
        # TODO barline only on CapellaXML 2.0
        events = getElements(noteObjects, ['rest', 'chord', 'barline'])
        # Hash der Infos über gesehene Bögen aufnimmt
        # n  = Index des EndeInfos
        # angle = Winkel des Bogenendes
        slurs_info = {}  # Winkel des Bogenendes
        slurs_y = {}     # y des Bogenendes
        event_index = 0
        for event in events:
          event_index += 1
          if latin1_e(event.nodeName) == 'chord':
            for drawObj in event.getElementsByTagName('drawObj'):
              slur = getElement(drawObj, 'slur')
              if slur:
                x3 = float(latin1_e(slur.getAttribute('x3')))
                y3 = float(latin1_e(slur.getAttribute('y3')))
                x4 = float(latin1_e(slur.getAttribute('x4')))
                y4 = float(latin1_e(slur.getAttribute('y4')))
                try:
                  angle = (y4-y3) / abs(x4-x3)
                except ZeroDivisionError:
                  angle = (y4-y3) / abs(x4-x3+1)
                basic = getElement(drawObj, 'basic')
                if basic and basic.hasAttribute('noteRange'):
                  noteRange = int(latin1_e(basic.getAttribute('noteRange')))
                else:
                  noteRange = 0
                slurs_info[event_index+noteRange] = angle
                slurs_y[event_index+noteRange] = y4
          # Bögen an Pausen rot färben
          elif latin1_e(event.nodeName) == 'rest':
            for drawObj in event.getElementsByTagName('drawObj'):
              slur = getElement(drawObj, 'slur')
              if slur:
                if slur.getAttribute('color') != '0000FF':
                  slur.setAttribute('color', errorColor)
        # Nun noch einmal durchlaufen und mit Bogenenden vergleichen
        event_index = 0
        for event in events:
          event_index += 1
          if latin1_e(event.nodeName) == 'chord':
            for drawObj in event.getElementsByTagName('drawObj'):
              slur = getElement(drawObj, 'slur')
              if slur and slurs_info.has_key(event_index):
                x1 = float(latin1_e(slur.getAttribute('x1')))
                y1 = float(latin1_e(slur.getAttribute('y1')))
                x2 = float(latin1_e(slur.getAttribute('x2')))
                y2 = float(latin1_e(slur.getAttribute('y2')))
                try:
                  angle = (y1-y2) / abs(x1-x2)
                except ZeroDivisionError:
                  angle = (y1-y2) / abs(x1-x2+1)
                end_angle = slurs_info[event_index]
                end_y = slurs_y[event_index]
                # Steigungswinkel sind fast gleich => zweiten Bogen einfärben
                if abs(angle+end_angle) < 0.3 and abs(end_y-y1) < 0.5:
                  slur.setAttribute('color', errorColor)
          # Pausen mit Endebögen rot färben
          elif latin1_e(event.nodeName) == 'rest':
            if slurs_info.has_key(event_index):
              set_chord_rest_color(event, errorColor)
  # Bögen färben die deutlich links von der Note enden
  # Bögen färben die deutlich rechts von der Note beginnen
  for drawObj in score.getElementsByTagName('drawObj'):
    slur = getElement(drawObj, 'slur')
    if slur:
      basic = getElement(drawObj, 'basic')
      if basic and basic.getAttribute('noteRange') not in [None, '1']:
        x1 = float(latin1_e(slur.getAttribute('x1')))
        x4 = float(latin1_e(slur.getAttribute('x4')))
        if x1 > 2.5 or x4 < -2.5:
          slur.setAttribute('color', errorColor)

# Gruppierungen erkennen und markieren
#TODO not linked
def grouping_separation(score):
  for voice in score.getElementsByTagName('voice'):
    lyrics = voice.getElementsByTagName('lyric')
    if len(lyrics) == 0:  # lyrics nicht beachten
      for chord in voice.getElementsByTagName('chord'):
        beam_ok = 0
        for beam in chord.getElementsByTagName('beam'):
          if beam.getAttribute('group') == 'split':
            beam_ok = 1
        # Noten an denen bereits {GS} steht nicht färben
        for text in chord.getElementsByTagName('text'):
          content = getElement(text, 'content')
          if content.lastChild is None:
            continue
          dtext = latin1_e(content.lastChild.nodeValue)
          if dtext == '{GS}':
            beam_ok = 0
        # Keine Färbung auf Vorschlagnoten
        duration = getElement(chord, 'duration')
        if duration.getAttribute('noDuration') == 'true':
          beam_ok = 0
        display = getElement(chord, 'display')
        if display:
          if display.getAttribute('color') and (display.getAttribute('color') in ['00FFFF', '008080', '40CCFF', '000080', '808000', '800080']+harmonyColors):
            beam_ok = 0
        if beam_ok == 1:
          set_chord_rest_color(chord, '7F0000')


# Färbung falls nach Silbenbindung Majuskel steht
def majuscle(L):
  return (L >= 'A' and L <= 'Z') or L in ['Ä', 'Ö', 'Ü']

# Prüft, ob auf ein - ein Makuskel folgt
# Prüft, ob auf ein . kein Majuskel folgt
def majuscle_verses(score):
  for voice in score.getElementsByTagName('voice'):
    # Übergehe Bassus continuos
    if is_basso_continuo(voice):
      continue
    # Array mit zugewiesenen Zuständen der Silbenbindung: 0 = keine Bindung, 1 = Bindung, 2 = alte Bindung übernehmen
    h = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    # Array mit den einzelnen verses, also den echten Liedtexten, falls keiner, so steht '', epsilon => alte übernehmen
    v = ['', '', '', '', '', '', '', '', '', '', '', '', '', '', '']
    # Array mit den einzelnen Satzzeichen, 0 => nicht notwendig Majuskel erwartet, 1 => stand Satzpunkt => notwendig Majuskel erwartet, 2 => alte übernehmen
    s = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    for chord in voice.getElementsByTagName('chord'):
      if not chord.getElementsByTagName('verse'):
        continue
      # Initialisierung
      nv = ['epsilon', 'epsilon', 'epsilon', 'epsilon', 'epsilon', 'epsilon', 'epsilon', 'epsilon', 'epsilon', 'epsilon', 'epsilon', 'epsilon', 'epsilon', 'epsilon', 'epsilon', 'epsilon']
      nh = [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2]
      for verse in chord.getElementsByTagName('verse'):
        i = int(latin1_e(verse.getAttribute('i')))
        if verse.hasChildNodes() and verse.lastChild != None:
          nv[i] = latin1_e(verse.lastChild.nodeValue)
        else:
          nv[i] = ''
        if verse.getAttribute('hyphen') == 'true':
          nh[i] = 1
        else:
          nh[i] = 0
      # Auswertung mit Anfärben
      for i in range(15):
        if len(nv[i]) == 0 or nv[i] in ['epsilon', 'x', "'-"]:
          continue
        lower = nv[i].lower()
        if (h[i] == 1 and nv[i][0] != lower[0]) or (s[i] == 1 and nv[i][0] == lower[0]):
          set_chord_rest_color(chord, errorColor)
          break
      # Daten für nächsten Akkord vorbereiten
      ns = [2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2]
      for verse in chord.getElementsByTagName('verse'):
        i = int(latin1_e(verse.getAttribute('i')))
        if verse.hasChildNodes() and verse.lastChild != None:
          verse_content = latin1_e(verse.lastChild.nodeValue)
          if verse_content.find('.') > -1:
            ns[i] = 1
          else:
            ns[i] = 0
      for i in range(15):
        if nh[i] != 2:
          h[i] = nh[i]
        if nv[i] != 'epsilon':
          v[i] = nv[i]
        if ns[i] != 2:
          s[i] = ns[i]

def kk_verses(score):
  for chord in score.getElementsByTagName('chord'):
    for verse in chord.getElementsByTagName('verse'):
      text = getText(verse)
      if len(text) > 3:
        hyphen = verse.getAttribute('hyphen')
        if ((text[-1] == '-' and text[-2] == 'k' and text[-3] != 'c') or
            (hyphen == 'true' and text[-1] == 'k' and text[-2] != 'c')):
          set_chord_rest_color(chord, hintColor)

# a . ber => a - ber
def dot_verses(score):
  starts_with_minuscle_regex = re.compile(u'^[a-zäöüé]', re.UNICODE)
  ending_with_dot = ['bzw.']
  for voice in score.getElementsByTagName('voice'):
    for noteObjects in voice.getElementsByTagName('noteObjects'):
      events = getElements(noteObjects, ['rest', 'chord', 'barline'])
      i = 0
      while i < len(events)-1:
        chord1 = events[i]
        chord2 = events[i+1]
        # Taktstriche außer :||, ||:, :||: überspringen
        if chord2.tagName == 'barline' and i < len(events)-2 and \
           chord2.getAttribute('type') not in ['repEnd', 'repBegin', 'repEndBegin']:
          chord2 = events[i+2]
        verses1 = chord1.getElementsByTagName('verse')
        verses2 = chord2.getElementsByTagName('verse')
        for verse1 in verses1:
          for verse2 in verses2:
            if verse1.getAttribute('i') == verse2.getAttribute('i'):
              if getText(verse1) != '' and getText(verse2).startswith('. '):
                verse1.setAttribute('hyphen', 'true')
                setText(verse2, getText(verse2)[1:].strip())
              if getText(verse1).endswith(' .'):
                verse1.setAttribute('hyphen', 'true')
                setText(verse1, getText(verse1)[:-1].strip())
              text1 = getText(verse1)
              if text1.endswith('.') and text1 not in ending_with_dot and \
                 not text1.endswith('...') and \
                 starts_with_minuscle_regex.match(getText(verse2)):
                verse1.setAttribute('hyphen', 'true')
                setText(verse1, text1[:-1].strip())
        i += 1

# Färbe Punktierte Noten ein, wenn dahinter einer künstliche Pause steht
def dot_check(score):
  time_ok = {} # 1 => prüfen da 4/4-Takt usw., bei 6/8 usw. dagegen keine Meldung = 0
  # Initialisieren von time_ok für alle staffs des Systems
  for staffLayout in score.getElementsByTagName('staffLayout'):
    staffName = latin1_e(staffLayout.getAttribute('description'))
    time_ok[staffName] = 0
  for staff in score.getElementsByTagName('staff'):
    staffName = latin1_e(staff.getAttribute('layout'))
    voiceState = time_ok[staffName]
    for voice in staff.getElementsByTagName('voice'):
      time_ok[staffName] = voiceState # Zu Beginn jeder Stimme den Zustand vom Anfang der Zeile wiederherstellen
      for noteObjects in voice.getElementsByTagName('noteObjects'):
        events = getElements(noteObjects, ['rest', 'chord', 'timeSign'])
        dot_info = {}
        invisible_info = {}
        event_index = 0
        # Zunächst auslesen der Infomationen
        for event in events:
          if event.getAttribute('time'):
            continue
          event_index += 1
          duration = getElement(event, 'duration')
          if duration and (duration.getAttribute('dots') == '1' or duration.getAttribute('dots') == '2'):
            dot_info[event_index] = 1
          else:
            dot_info[event_index] = 0
          display = getElement(event, 'display')
          if display and display.getAttribute('invisible') == 'true':
            invisible_info[event_index] = 1
          else:
            invisible_info[event_index] = 0
        invisible_info[event_index+1] = 0
        event_index = 0
        s = re.compile('[369]/[1248]')
        t = re.compile('[2468]/[1248]|C|allaBreve')
        for event in events:
          if event.getAttribute('time') and s.match(event.getAttribute('time')):
            time_ok[staffName] = 0
            continue
          if event.getAttribute('time') and t.match(event.getAttribute('time')):
            time_ok[staffName] = 1
            continue
          if time_ok[staffName] == 0:
            continue
          if event.getAttribute('time'):
            continue  # Damit event-index nicht weiter hochgezählt wird
          event_index += 1
          if dot_info[event_index] == 1 and invisible_info[event_index+1] == 1:
            set_chord_rest_color(event, errorColor)


# Noten mit Artikulationszeichen rot färben falls Liedtexte vorhanden
def lyrical_accidentals(score):
  # Zunächst alle Systeme feststellen, die geschweifte Klammern haben (= Klavier, hier gilt die Prüfung nicht) in Array speichern (index)
  curly_staff = []
  curly_staff_h = {}
  for layout in score.getElementsByTagName('layout'):
    for stafflayout in layout.getElementsByTagName('staffLayout'):
      curly_staff.append('false')
    for brackets in layout.getElementsByTagName('brackets'):
      for bracket in brackets.getElementsByTagName('bracket'):
        if bracket.getAttribute('curly') == 'true':
          from_system = int(bracket.getAttribute('from'))
          to_system = int(bracket.getAttribute('to'))
          for i in range (from_system, to_system+1):
            curly_staff[i] = 'true'
    staff_i = -1
    for stafflayout in layout.getElementsByTagName('staffLayout'):
      staff_i += 1
      description = stafflayout.getAttribute('description')
      curly_staff_h[description] = 'false'
      if curly_staff[staff_i] == 'true':
        curly_staff_h[description] = 'true'
  for system in score.getElementsByTagName('system'):
    for staff in system.getElementsByTagName('staff'):
      description = staff.getAttribute('layout')
      if curly_staff_h[description] == 'false': # Nur Systeme ohne geschweifte Klammern auswerten
        for voice in staff.getElementsByTagName('voice'):
          if is_basso_continuo(voice):
            continue
          verse = voice.getElementsByTagName('verse')
          if verse != []:
            for chord in voice.getElementsByTagName('chord'):
              articulation = getElement(chord, 'articulation')
              if articulation and articulation.getAttribute('type') != 'normalAccent' and articulation.getAttribute('type') != 'staccatissimo':
                set_chord_rest_color(chord, errorColor)
                
def lyrical_extenders(score):
  for verse in score.getElementsByTagName('verse'):
    if verse.getAttribute('extender') == 'true':
      verse.setAttribute('extender', 'false')

# Stichnoten mit Artikulationszeichen rot färben
def grace_accidentals(score):
  for chord in score.getElementsByTagName('chord'):
    duration = getElement(chord, 'duration')
    if duration.getAttribute('noDuration') == 'true':
      articulation = getElement(chord, 'articulation')
      if articulation:
        set_chord_rest_color(chord, errorColor)


# Solche Noten blau färben, deren Versetzungszeichen und Tonhöhe so bereits bei einer
# anderen Note desselben Staffs aber anderer Stimme auftauchen
#TODO not linked
def blue_accidental(score):
  for staff in score.getElementsByTagName('staff'):
    alter_pitch = {} # Liste aller pitches
    alter_info = {}  # In welchen Stimmen tauch dieser pitch auf
    alter_info2 = {} # Mit welchen alters erscheint dieser pitch
    voice_nr = 0
    # Einlesen der Alter-Informationen in die Datenbank
    for voice in staff.getElementsByTagName('voice'):
      voice_nr += 1
      for head in voice.getElementsByTagName('head'):
        pitch = latin1_e(head.getAttribute('pitch'))
        alter_pitch[pitch] = 0  # Hash mit allen auftretenden Pitches
        alter_count = 0
        for alter in head.getElementsByTagName('alter'):
          alter_count += 1
          alter_state = latin1_e(alter.getAttribute('display'))
          if alter_state == '' or alter_state == 'auto':
            alter_info[pitch+'#'+str(voice_nr)] = 1
          elif alter_state == 'force':
            alter_info[pitch+'#'+str(voice_nr)] = 0
          # Welche Alters wurden zusammen mit einem pitch gesehen
          alter_step = latin1_e(alter.getAttribute('step'))
          alter_info2[pitch+'##'+alter_step] = 1
        # Falls es keinen alter-Eintrag im Pitch gibt, so 0 einstellen
        if alter_count == 0:
          alter_info2[pitch+'##0'] = 1
    # Verschiedenartige alters je pitch durch aufsummieren erkennen
    for pitch in alter_pitch.keys():
      if alter_info2.has_key(pitch+'##-2'):
        alter_pitch[pitch] += 1
      if alter_info2.has_key(pitch+'##-1'):
        alter_pitch[pitch] += 1
      if alter_info2.has_key(pitch+'##0'):
        alter_pitch[pitch] += 1
      if alter_info2.has_key(pitch+'##1'):
        alter_pitch[pitch] += 1
      if alter_info2.has_key(pitch+'##2'):
        alter_pitch[pitch] += 1
    # Anwenden der Alterinformationen
    for chord in staff.getElementsByTagName('chord'):
      for head in chord.getElementsByTagName('head'):
        pitch = latin1_e(head.getAttribute('pitch'))
        #debug(pitch+"   "+str(alter_pitch[pitch]))
        if alter_pitch[pitch] > 1:
          for alter in head.getElementsByTagName('alter'):
            alter_state = latin1_e(alter.getAttribute('display'))
            if alter_state in ['', 'auto', 'force']:
              if (alter_info.has_key(pitch+'#1') and alter_info.has_key(pitch+'#2')) or \
                 (alter_info.has_key(pitch+'#1') and alter_info.has_key(pitch+'#3')) or \
                 (alter_info.has_key(pitch+'#2') and alter_info.has_key(pitch+'#3')):
                set_chord_rest_color(chord, '0000FE')


# Färben wenn Anfang stark von Note abweichend und es Gesangsnoten sind (einfügen künstliche Pause)
def wedge_hints(score):
  for staff in score.getElementsByTagName('staff'):
    if len(staff.getElementsByTagName('lyric')):
      for wedge in staff.getElementsByTagName('wedge'):
        if float(wedge.getAttribute('x1')) < -3:
          wedge.setAttribute('color', hintColor)

# Färben wenn einzeln stehendes Rechteck ohne Text
def rectangle_hints(score):
  for tag in ['chord', 'rest', 'barline']:
    for event in score.getElementsByTagName(tag):
      rectangle = getElement(event, 'drawObjects', 'drawObj', 'rectangle')
      if rectangle:
        text = getElement(event, 'drawObjects', 'drawObj', 'text')
        if not text:
          rectangle.setAttribute('lineColor', errorColor)

# Färbe Bindebögen zur besseren Unterscheidung von Haltebögen (green_slurs)
def colored_slurs(score):
  for drawObj in score.getElementsByTagName('drawObj'):
    for slur in drawObj.getElementsByTagName('slur'):
      if not slur.getAttribute('color') or  slur.getAttribute('color') == '000000':
        form = slur.getElementsByTagName('form')
        basic = getElement(drawObj, 'basic')
        if form:
          slur.setAttribute('color', hintColor)
          for form in slur.getElementsByTagName('form'):
            form.setAttribute('endWidth', '0.25')
            form.setAttribute('midWidth', '0.25')
            form.setAttribute('dotDist', '1')
            form.setAttribute('dotWidth', '0.75')
        else:
          # korrigiere x1 und x4 = Bogenposition normalisieren, bei Überhängen dunkelgrün
          slur.setAttribute('color', slurColor)
          if not basic or basic.getAttribute('noteRange') == '' or int(basic.getAttribute('noteRange')) == 0:
            slur.setAttribute('color', harmonyColor)
          else:
            if float(slur.getAttribute('x4').replace(',',''))*32.0 <= 55.0:
              pass
              #slur.setAttribute('x3', str(float(slur.getAttribute('x3'))-float(slur.getAttribute('x4'))))
              #slur.setAttribute('x4', '0.0')
            else:
              slur.setAttribute('color', harmonyColor)
            if float(slur.getAttribute('x1').replace(',',''))*32.0 >= -10.0:
              pass
              #slur.setAttribute('x1', '1.0')
              #slur.setAttribute('x2', str(float(slur.getAttribute('x2'))+float(slur.getAttribute('x1'))))
            else:
              slur.setAttribute('color', harmonyColor)

# Falls Bogen auf grace beginnt und endet so färben
def grace_slurs(score):
  rng = -1
  for chord in score.getElementsByTagName('chord'):
    duration = getElement(chord, 'duration')
    if duration and duration.getAttribute('noDuration') == 'true':
      for drawObj in chord.getElementsByTagName('drawObj'):
        if getElement(drawObj, 'slur'):
          slur = getElement(drawObj, 'slur')
          basic = getElement(drawObj, 'basic')
          if basic and basic.getAttribute('noteRange') != None:
            try:
              # Fehler bei capella, das Attribut wird erzeugt, steht aber nicht im Original
              prerange = int(basic.getAttribute('noteRange'))
              if rng < 0 or (prerange > 0 and prerange < rng):
                rng = prerange
            except: pass
    if rng == 0 and duration and duration.getAttribute('noDuration') == 'true':
      slur.setAttribute('color', errorColor)
      set_chord_rest_color(chord, errorColor)
    rng -= 1

# Wörter in der zweiten Simme anfärben
def second_voice(score):
  for voices in score.getElementsByTagName('voices'):
    voice_nr = 1
    for voice in voices.getElementsByTagName('voice'):
      if voice_nr == 1:
        voice_nr = 2
      else:
        for wedge in voice.getElementsByTagName('wedge'):
          if wedge.getAttribute('color') == '000000':
            wedge.setAttribute('color', hintColor)
        for text in voice.getElementsByTagName('text'):
          font = getElement(text, 'font')
          if font.getAttribute('color') not in harmonyColors:
            font.setAttribute('color', hintColor)
        if voice_nr == 2:
          for chord in voice.getElementsByTagName('chord'):
            set_chord_rest_color(chord, '555522')
          for rest in voice.getElementsByTagName('rest'):
            set_chord_rest_color(rest, '555522')
          voice_nr += 1
        else:
          for chord in voice.getElementsByTagName('chord'):
            set_chord_rest_color(chord, '222266')
          for rest in voice.getElementsByTagName('rest'):
            set_chord_rest_color(rest, '222266')


def second_pitch(score):
  for chord in score.getElementsByTagName('chord'):
    pitches = []
    for pitch in chord.getElementsByTagName('head'):
      pitches.append(latin1_e(pitch.getAttribute('pitch')))
    if len(pitches) != len(dict.fromkeys(pitches).keys()):
      set_chord_rest_color(chord, errorColor)

# Zeige Wörter an, die falsch sein könnten
def erronous_words(score):
  p = re.compile('^[*PpfiIl/\\\\\\]\\[(){}jJ!«»689SsTty?]$')
  numberdot = re.compile('^\d+\.$')
  is_guitar = False
  is_accordion = False
  for text in score.getElementsByTagName('text'):
    font = getElement(text, 'font')
    if not font or not font.getAttribute('face') == 'capella3':
      content = getElement(text, 'content')
      if content.lastChild is None:
        continue
      dtext = latin1_e(content.lastChild.nodeValue)
      if dtext.upper().strip() == '{GUITAR}':
        is_guitar = True
      if dtext.upper().strip() == '{ACCORDION}':
        is_accordion = True
      if is_guitar and dtext in ['p', 'i']:
        pass
      elif is_accordion and dtext in ['f']:
        pass
      else:
        if p.match(dtext):
          setFont(font, bold=True)
          font.setAttribute('height', '16')
          font.setAttribute('color', errorColor)
          font.setAttribute('face', errorFont)
          font.setAttribute('underline', 'true')
        # fehlgeleitete Strophennummern ...
        if numberdot.match(dtext) and text.getAttribute('y')[0] != '-':
          setFont(font, bold=True)
          font.setAttribute('height', '16')
          font.setAttribute('color', errorColor)
          font.setAttribute('face', errorFont)
          font.setAttribute('underline', 'true')
#  for drawObjects in score.getElementsByTagName('drawObjects'):
#    i = 0
#    while i < len(drawObjects)-1:
#      drawObj1 = drawObjects.item(i)
#      drawObj2 = drawObjects.item(i+1)
#      text1 = getElement(drawObj1, 'text')
#      text2 = getElement(drawObj2, 'text')
#      if text1.getAttribute('x') == text2.getAttribute('x') and \
#         text1.getAttribute('y') == text2.getAttribute('y'):
#        drawObjects.drop(i+1)
#      i += 1


def verse_errors(score):
  # Entferne zunächst alle führenden und endenden Leerzeichen bei Liedtexten
  for verse in score.getElementsByTagName('verse'):
    setText(verse, getText(verse).strip())
  p = re.compile(u'^"?[A-ZÄÖÜÆÅÀÂÈÉÊËÎÏÔØŒÙÛa-zäöüæåàâèéêëîïôøœùûß][a-zäöüæåàâèéêëîïôøœùûß\\-\']*[.,;:!?]?( [A-ZÄÖÜÆÅÀÂÈÉÊËÎÏÔØŒÙÛa-zäöüæåàâèéêëîïôøœùûß][a-zäöüæåàâèéêëîïôøœùûß]*[.,;:!?]?)*"?-?_?$', re.UNICODE)
  # Keine Selbstlaute
  q = re.compile('(^"?|^.* )[B-Db-dF-Hf-hJ-Nj-nP-Tp-tV-XZv-xzß\']+[.,;:!?]?( .*$|"?-?_?$)')
  # endet auf j
  r = re.compile('^.*j$')
  # Falsche Buchstabengruppen
  t = re.compile('ii|Ii')
  # Silben by, dy, fy, gy, ly, my, ny, py, ry, sy, ty wie ve-ri-fy usw. tolerieren
  s = re.compile('^([bdfglmnprst]|th)y[.,;:!?]?$')
  s2 = re.compile(u'^.*[aeiouäöüæåàâèéêëîïôøœùû][^aeiouäöüæåàâèéêëîïôøœùû]+[aeiouäöüæåàâèéêëîïôøœùû].*$', re.UNICODE)
  # Typische Wörter, die immer wieder falsch sind
  u = re.compile('^(Hirn|ai|toil|tern|gè|Hai)$')
  # wie u allerdings Wörter ohne Bindestrich
  u2 = re.compile('^(mei)[.,?!]?$')
  correct = {'Hirn':'Him','ai':'al','toil':'toll','tern':'tem','gè':'ge','Hai':'Hal','mei':'mel'}
  # Silben mit Leerzeichen oder - dazwischen
  v_regex = re.compile(r'^.*[^\\ -][ -][^ -].*$')
  w_regex = re.compile(r'.*[.!?][")]|[")][.,;:!?]')
  oe_regex = re.compile(r'(boeuf|choeur|coeur|oeuf|moeurs|noeud|oeil|soeur|voeu)[,.?!]?$')
  for voice in score.getElementsByTagName('voice'):
    if is_basso_continuo(voice):
      continue
    for chord in voice.getElementsByTagName('chord'):
      duration = '1/1'
      for duration in chord.getElementsByTagName('duration'):
        duration = latin1_e(duration.getAttribute('base'))
      for lyric in chord.getElementsByTagName('lyric'):
        for verse in lyric.getElementsByTagName('verse'):
          if verse.hasChildNodes() and verse.lastChild != None:
            dtext = latin1_e(verse.lastChild.nodeValue)
            if dtext in ["'-", 'x']:
              continue
            #  Anfärben von Silben mit enthaltenen Leerzeichen oder (echten) Bindestrichen
            if v_regex.match(dtext) or w_regex.match(dtext):
              set_chord_rest_color(chord, slurColor)
            # Ligaturen reparieren oe => œ
            elif oe_regex.match(dtext):
              dtext = dtext.replace('oe', 'œ')
              verse.lastChild.nodeValue = latin1_d(dtext)
            # Fehler anfärben
            elif not s.match(dtext) and not s2.match(dtext): # Übergehen bei zu tolerierenden Silben (englisch)
              shorted_dtext = dtext
              shorted_dtext = shorted_dtext.replace('st', 's', 10)
              shorted_dtext = shorted_dtext.replace('sch', 's', 10)
              shorted_dtext = shorted_dtext.replace('ch', 'c', 10)
              if (len(shorted_dtext) > 6 and duration in ['1/4', '1/8', '1/16', '1/32', '1/64']) or \
                 not p.match(dtext) or q.match(dtext) or r.match(dtext) or t.match(dtext) or \
                 u.match(dtext) or (u2.match(dtext) and verse.getAttribute('hyphen') != 'true'):
                if first_call(score) and dtext in correct:
                  verse.lastChild.nodeValue = correct[dtext]
                else:
                  set_chord_rest_color(chord, errorColor2)
          else: # Keine Texte enthalten, aber Strophennummer => anfärben
            if verse.getAttribute('verseNumber'):
              set_chord_rest_color(chord, errorColor2)

# Seltene Liedtextsilben ankreuzen
def rare_verses(score):
  r = re.compile('[.,;:?!_ ]*') # Fingersätze mit Leerzeichen
  verses = {}
  verse_count = 0 # Wieviele verse insgesamt
  max_count = 0   # Wie groß ist die Anzahl der am häuigsten gesehenen Silbe
  for verse in score.getElementsByTagName('verse'):
    if verse.hasChildNodes() and verse.lastChild != None:
      dtext = latin1_e(verse.lastChild.nodeValue)
      lower = dtext.lower()
      lower = r.sub('', lower)
      assert ',' not in lower
      if verse.getAttribute('hyphen') == 'true':
        lower += '-'
      if lower in verses: verses[lower] = verses[lower]+1
      else: verses[lower] = 1
      verse_count += 1
  # Auswerten, welche Häufifkeiten wie oft gesehen wurden
  counts = {}
  for lower in verses.keys():
    if verses[lower] in counts: counts[verses[lower]] = counts[verses[lower]]+1
    else: counts[verses[lower]] = 1
    if verses[lower] > max_count:
      max_count = verses[lower]
  # max_count = die häufisgte Häufigkeit (bspw. 33 => ein Wort wurde 33 mal gesehen)
  # counts[1] = wieviele Wörter wurden 1 mal gesehen
  if counts.has_key(1) and max_count > counts[1]:
    #debug(str(max_count)+'  '+str(counts[1]))
    for voice in score.getElementsByTagName('voice'):
      if is_basso_continuo(voice):
        continue
      for chord in voice.getElementsByTagName('chord'):
        for verse in chord.getElementsByTagName('verse'):
          if verse.hasChildNodes() and verse.lastChild != None:
            dtext = latin1_e(verse.lastChild.nodeValue)
            lower = dtext.lower()
            lower = r.sub('', lower)
            if verse.getAttribute('hyphen') == 'true':
              lower += '-'
            if verses.has_key(lower) and verses[lower] == 1:
              set_chord_rest_color(chord, hintColor)

def space_verses(score):
  space_texts = []
  texts = []
  for verse in score.getElementsByTagName('verse'):
    text = stripMarks(getText(verse))
    if ' ' in text:
      space_texts.append(text)
      space_texts.append(text.replace(' ', ''))
    else:
      texts.append(text)
  for chord in score.getElementsByTagName('chord'):
    for verse in chord.getElementsByTagName('verse'):
      text = stripMarks(getText(verse))
      if text in texts and text in space_texts:
        set_chord_rest_color(chord, hintColor)

# Falsche Zeichen in Verse-Number/ Unerwartetes Verse-Number
def verse_numbers(score):
  space_regex = re.compile(r'\s+')
  verse_number_regex = re.compile(r'^\d\.(\+\d\.)?$')
  for voice in score.getElementsByTagName('voice'):
    if is_basso_continuo(voice):
      continue
    for chord in voice.getElementsByTagName('chord'):
      for verse in chord.getElementsByTagName('verse'):
        if verse.getAttribute('verseNumber') not in [None, '']:
          verse.setAttribute('verseNumber', space_regex.sub('', verse.getAttribute('verseNumber')))
          if verse_number_regex.match(verse.getAttribute('verseNumber')) == None:
            set_chord_rest_color(chord, errorColor)

# Arpeggio-Tests
def k_to_arpeggio(score):
  for text in score.getElementsByTagName('text'):
    content = getElement(text, 'content')
    if content.lastChild is None:
      continue
    dtext = latin1_e(content.lastChild.nodeValue)
    font = getElement(text, 'font')
    if font.getAttribute('face') != 'capella3' and dtext == 'k':
      setFont(font)
      font.setAttribute('face', 'capella3')
      text.setAttribute('x', '-1.8')
      content.lastChild.nodeValue = unichr(173)

def _is_arpeggio(text):
  font = getElement(text, 'font')
  if font and font.getAttribute('face').startswith('capella'):
    content = getElement(text, 'content')
    if content.lastChild is None:
      return False
    dtext = latin1_e(content.lastChild.nodeValue)
    return dtext in ['¬', '­', '¼', '»']
  return False

# Falls Arpeggio an Pause so rot
def check_arpeggio(score):
  for rest in score.getElementsByTagName('rest'):
    for text in rest.getElementsByTagName('text'):
      if _is_arpeggio(text):
        font = getElement(text, 'font')
        font.setAttribute('color', errorColor)

def is_basso_continuo(voice):
  assert voice.tagName == 'voice'
  lyricsSettings = getElement(voice, 'lyricsSettings')
  if lyricsSettings:
    font = getElement(lyricsSettings, 'font')
    if font:
      if latin1_e(font.getAttribute('color')) == bcColor:
        return True
  return False

# Bässe, bezifferte Bässe, figured basses, figured_basses
# basso continuo: Inhalte prüfen, Noten einfärben etc.
def basso_continuo(score):
  doc = score.parentNode
  p = re.compile('^([\[\(]?(([123456789]|10)[/\\+#bn]?|[/\\\+#bn]?([123456789]|10)|[bn#~])[\]\)]?|.)?((\{(1|2|4|8|16|32)\.{0,3}\})?_[\[\(]?(([123456789]|10)[/\\\+#bn]?|[/\\\+#bn]?([123456789]|10)|[bn#~])[\]\)]?)*$')
  for voice in score.getElementsByTagName('voice'):
    lyric_extenders = ['false', 'false', 'false', 'false', 'false', 'false', 'false', 'false', 'false', 'false']
    if is_basso_continuo(voice):
      for chord in voice.getElementsByTagName('chord'):
        # Auswerten der alten extender
        lyric_extenders = ['false', 'false', 'false', 'false', 'false', 'false', 'false', 'false', 'false', 'false']
        for verse in chord.getElementsByTagName('verse'):
          i = int(latin1_e(verse.getAttribute('i')))
          verse.setAttribute('hyphen', 'false')
          pre_text = latin1_e(verse.getAttribute('verseNumber')).replace(',', '_')
          #if len(pre_text):
          #  pre_text = pre_text+'#'
          verse.setAttribute('verseNumber', '')
          if verse.hasChildNodes() and verse.lastChild != None:
            dtext = pre_text+latin1_e(verse.lastChild.nodeValue)
            if dtext == '-':
              dtext = '~'
            dtext = dtext.replace(',', '_')
            setText(verse, dtext)
            if '_' in pre_text:
              assert pre_text.find('_') > -1
            if len(pre_text) > 3 or pre_text.find('_') > -1:
              verse.setAttribute('align', 'left')
            else:
              verse.setAttribute('align', 'left') # center
          else:
            newtext = doc.createTextNode(latin1_d(pre_text))
            verse.appendChild(newtext)
          if getText(verse) != '' and not p.match(getText(verse)):
            set_chord_rest_color(chord, errorColor)
          if verse.getAttribute('extender') == 'true':
            lyric_extenders[i] = 'true'
            verse.setAttribute('extender', 'false')

# Entferne Klammern bei tuplets, die nicht benötigt werden
def tuplet_brackets(score):
  for voice in score.getElementsByTagName('voice'):
    for noteObjects in voice.getElementsByTagName('noteObjects'):
      events = getElements(noteObjects, ['rest', 'chord'])
      event_index = 0
      for event in events:
        for drawObjects in event.getElementsByTagName('drawObjects'):
          for drawObj in event.getElementsByTagName('drawObj'):
            for bracket in drawObj.getElementsByTagName('bracket'):
              for basic in drawObj.getElementsByTagName('basic'):
                try:
                  if basic.getAttribute('noteRange') == '2' and bracket.getAttribute('number') == '3' and latin1_e(event.nodeName) == 'chord' and latin1_e(events[event_index+1].nodeName) == 'chord' and latin1_e(events[event_index+2].nodeName) == 'chord':
                    duration0 = events[event_index].getElementsByTagName('duration')[0]
                    duration1 = events[event_index+1].getElementsByTagName('duration')[0]
                    duration2 = events[event_index+2].getElementsByTagName('duration')[0]
                    if duration0.getAttribute('base') in ['1/8', '1/16', '1/32', '1/64', '1/128'] and \
                       duration1.getAttribute('base') in ['1/8', '1/16', '1/32', '1/64', '1/128'] and \
                       duration2.getAttribute('base') in ['1/8', '1/16', '1/32', '1/64', '1/128']:
                      drawObjects.removeChild(drawObj)
                except IndexError: 
                  dummy = 5
        event_index += 1
                
# Extra Zeilenabstände zwischen die Systeme einfügen
# am Ende einen großen Abstand erzeugen
def extra_distance(score):
  b_offset = 0 # Offset nach unten
  staffs = score.getElementsByTagName('staff')
  for staff in staffs:
    extra_distances = staff.getElementsByTagName('extraDistance')
    if len(extra_distances) == 0:
      extra_distance = createNewChildBefore(staff, 'extraDistance', attrib={'top':'2', 'bottom':'2'})
  for staff in staffs:
    extra_distances = getElements(staff, ['extraDistance'])
    if len(extra_distances) > 0:
      extra_distance = extra_distances[0]
      if extra_distance.getAttribute('top'):
        u_offset = int(latin1_e(extra_distance.getAttribute('top')))
      else:
        u_offset = 0
      if b_offset+u_offset < 4:
        u_offset = 4-b_offset
      extra_distance.setAttribute('top', latin1_d(str(u_offset)))
      b_offset = 0
      if extra_distance.getAttribute('bottom'):
        b_offset = int(latin1_e(extra_distance.getAttribute('bottom')))
  # minimum distance to the top
  for extra_distance in staffs[0].getElementsByTagName('extraDistance'):
    if extra_distance.getAttribute('top') != None and int(extra_distance.getAttribute('top')) < 10:
      extra_distance.setAttribute('top', '10')
  # minimum distance to the bottom
  for extra_distance in staffs[-1].getElementsByTagName('extraDistance'):
    try:
      if extra_distance.getAttribute('bottom') != None and \
         int(extra_distance.getAttribute('bottom')) < 30:
        extra_distance.setAttribute('bottom', '30')
    except ValueError:
      extra_distance.setAttribute('bottom', '30')
  # weniger Abstand bei Partituren
  for system in score.getElementsByTagName('system'):
    system_staffs = system.getElementsByTagName('staff')
    for system_staff in system_staffs:
      extra_distance = system_staff.getElementsByTagName('extraDistance')[0]
      if len(system_staffs) > 12:
        extra_distance.setAttribute('top', '0')
        extra_distance.setAttribute('bottom', '0')
      elif len(system_staffs) > 10:
        extra_distance.setAttribute('top', '1')
        extra_distance.setAttribute('bottom', '1')
      elif len(system_staffs) > 9:
        extra_distance.setAttribute('top', '2')
        extra_distance.setAttribute('bottom', '2')
  # min distance of 10
  extraDistances = score.getElementsByTagName('extraDistance')
  i = 0
  while i < len(extraDistances)-1:
    try:
      bottom = int(extraDistances[i].getAttribute('bottom'))
    except:
      bottom = 0
    try:
      top = int(extraDistances[i+1].getAttribute('top'))
    except:
      bottom = 0
    if bottom+top < 10:
      top_add = top+(10-bottom-top)//2
      bottom_add = bottom+(10-bottom-top)//2
      extraDistances[i].setAttribute('bottom', str(bottom_add))
      extraDistances[i+1].setAttribute('top', str(top_add))
    i += 1

# Farbliche Markierung von möglicherweise falsch zugeordneten  /verankerten Symbolen oder Texten
def assignments(score):
  # Voltenklammern müssen richtig verbunden sein
  for volta in score.getElementsByTagName('volta'):
    if volta.getAttribute('firstNumber'):
      x1 = float(latin1_e(volta.getAttribute('x1')))
      if x1 > 1.3:
        volta.setAttribute('color', errorColor)
      x2 = float(latin1_e(volta.getAttribute('x2')))
      if x2 < -1.3:
        volta.setAttribute('color', errorColor)
  # Falsch verankerte Symbole
  for text in score.getElementsByTagName('text'):
    for font in text.getElementsByTagName('font'):
      if font.getAttribute('face') == 'capella3':
        x = float(latin1_e(text.getAttribute('x')))
        for content in text.getElementsByTagName('content'):
          if content.hasChildNodes() and content.lastChild != None:
            all_text = latin1_e(content.lastChild.nodeValue)
            if x > 0 and (content in ['-', '¬', '»', '¼']):
              font.setAttribute('color', errorColor)
            # utf-8-Zeichen, zum Beispiel verschobene Tenuti
            if (x > 1.5 or x < -1) and len(all_text) > 1 and ord(all_text[0]) == 195 and ord(all_text[1]) in [136]:
              font.setAttribute('color', errorColor)
      else:
        x = float(latin1_e(text.getAttribute('x')))
        y = float(latin1_e(text.getAttribute('y')))
        for content in text.getElementsByTagName('content'):
          if content.hasChildNodes() and content.lastChild != None:
            all_text = latin1_e(content.lastChild.nodeValue)
            # Text steht rechts über den Noten => markieren
            if x > 1.5 and y < -3 and len(all_text) and isalpha(all_text[0]):
              font.setAttribute('color', hintColor)
            if (x < 1 or x > 1) and all_text in ['_', '-', '.', '<', '>']:
              font.setAttribute('color', errorColor)


def _normalize_command(command):
  commands = {'PLUCKING-INSTRUMENT' : 'PLUCKING',
              'WIND-INSTRUMENT' : 'WIND',
              'STRING-INSTRUMENT' : 'STRING',
              'DOUBLEBASS' : 'BASS',
              'DOUBLE-BASS' : 'BASS',
              'DOT-3' : '3-DOT',
              'COINCIDENCE' : 'JOIN',
              'OA-Z' : 'O-Z',
              'OB-Z' : 'O-Z',
              'GANZE' : 'WHL',
              'MAXIMA' : 'MXM',
              'LUNGA' : 'LNG',
              'BREVIS' : 'BRV',
              'VOCALCONTINUES' : 'VOCAL-CONTINUES',
              'SOLO-PART' : 'SOLOPART',
              'DIRECTION:INVERTED' : 'DIR:INV',
              'DIR:INVERTED' : 'DIR:INV',
              'DIRECTION:INV' : 'DIR:INV',
              'RH:DIRECTION:INVERTED' : 'RHI',
              'RH:DIR:INVERTED' : 'RHI',
              'RH:DIR:INV' : 'RHI',
              'RH:INV' : 'RHI',
              'RH:DIRECTION:INV' : 'RHI',
              'LH:DIRECTION:INVERTED' : 'LHI',
              'LH:DIR:INV' : 'LHI',
              'LH:INV' : 'LHI',
              'LH:DIR:INVERTED' : 'LHI',
              'LH:DIRECTION:INV' : 'LHI',
              '(W<A' : '(W<A)',
              '(W>A' : '(W>A)',
              '(W<Z' : '(W<Z)',
              '(W>Z' : '(W>Z)',
              'W<A)' : '(W<A)',
              'W>A)' : '(W>A)',
              'W<Z)' : '(W<Z)',
              'W>Z)' : '(W>Z)',
              '[W<A' : '[W<A]',
              '[W>A' : '[W>A]',
              '[W<Z' : '[W<Z]',
              '[W>Z' : '[W>Z]',
              'W<A]' : '[W<A]',
              'W>A]' : '[W>A]',
              'W<Z]' : '[W<Z]',
              'W>Z]' : '[W>Z]',
              '(<-'  : '(<-)',
              '<-)'  : '(<-)',
              '[<-'  : '[<-]',
              '<-]'  : '[<-]',
              '(AN'  : '(AN)',
              'AN)'  : '(AN)',
              '[AN'  : '[AN]',
              'AN]'  : '[AN]',
              'DIRECTIVE' : 'DIR',
              'FOOTNOTE' : 'FN',
              'FNOTE' : 'FN',
              'FOOTN' : 'FN',
              'ORCHESTRATION' : 'O',
              'KOMPONIST' : 'CREATOR',
              'COMPOSER' : 'CREATOR',
              'LTEXT' : 'LTXT',
              'SOURCE' : 'SRC',
              'ENDING' : 'VOLTA',
              'PLAYTIME' : 'DURATION',
              'PLAY-TIME' : 'DURATION',
              'PERFORMANCE' : 'PRFM',
              'TEXT' : 'TXT',
              'SUBTITLE' : 'SUB-TITLE',
              'STITLE' : 'SUB-TITLE',
              'SUPERTITLE' :'SUPER-TITLE',
              'VARIANTE' : 'VARIANT',
              'ATACA' : 'ATTACCA',
              'ATTACA' : 'ATTACCA',
              'ATACCA' : 'ATTACCA',
              'INSTRUMENT' : 'I',
              'SECTION' : 'S',
              'PAGE' : 'P',
              'LPAGE' : 'LP',
              'LASTPAGE' : 'LP',
              'LASTP' : 'LP',
              'MEASURE-NUMBER' : 'M',
              'MEASURENUMBER' : 'M',
              'MNUMBER' : 'M',
              'MNR' : 'M',
              'TUPLET' : 'X',
              'TUPLETS' : 'XX',
              'TRIPLET' : 'X',
              'TRIPLETS' : 'XX',
              'FOOT-NOTE-REFERENCE' : 'FNR',
              'FOOTNOTE-REFERENCE' : 'FNR',
              'FNOTE-REFERENCE' : 'FNR',
              'FN-REFERENCE' : 'FNR',
              'FOOT-NOTE-REF' : 'FNR',
              'FOOTNOTE-REF' : 'FNR',
              'FNOTE-REF' : 'FNR',
              'FN-REF' : 'FNR',
              'FOOT-NOTE-R' : 'FNR',
              'FOOTNOTE-R' : 'FNR',
              'FNOTE-R' : 'FNR',
              'FN-R' : 'FNR',
              'MOVING' : 'MOVE',
              'SIZES-A' : 'SIZE-A',
              'SIZES-Z' : 'SIZE-Z',
              'HINWEIS' : 'H',
              'HINT' : 'H',
              'MESSAGE' : 'H',
              'REHEARSAL' : 'R',
              'RANGE' : 'AMBITUS',
              'ORGAN-PEDALS' : 'OP',
             }
  if commands.has_key(command):
    return commands[command]
  else:
    return command

###############################################################################
    
def text_exists(score, cmptext):
  for text in score.getElementsByTagName('text'):
    content = getElement(text, 'content')
    if content and content.lastChild != None:
      ttext = latin1_e(content.lastChild.nodeValue)
      if cmptext.lower() in ttext.lower():
        return True
  return False

def duration_sum(events):
  duration = 0.0
  for event in events:
    dur = getElement(event, 'duration')
    if dur.getAttribute('base').startswith('2/'):
      duration += 2/float(dur.getAttribute('base').replace('2/', ''))
    else:
      duration += 1/float(dur.getAttribute('base').replace('1/', ''))
  return duration

def _has_creator_prefix(ttext):
  for prefix in ['Text:', 'Text nach', 'Musik:', 'Satz:']:
    if ttext.lower().startswith(prefix.lower()):
      return True
  return False

def titles_etc(score):
  for text in score.getElementsByTagName('text'):
    content = getElement(text, 'content')
    if content.lastChild != None:
      dtext = latin1_e(content.lastChild.nodeValue)
      if dtext.startswith('{'):
        pass
      elif len(dtext) < 5:
        pass
      elif dtext.startswith('(c)') or dtext.startswith('(C)') or \
           dtext.startswith('©') or \
           '\n(c)' in dtext or '\n(C)' in dtext:
        content.lastChild.nodeValue = '{RIGHTS:'+dtext+'}'
  if not first_call(score, ['command']):
    return
  for staff in score.getElementsByTagName('staff'):
    for voice in staff.getElementsByTagName('voice'):
      directive_exists = text_exists(score, '{DIRECTIVE:') or text_exists(score, '{DIR:')
      lcaption_exists = text_exists(score, '{LCAPTION:')
      title_exists = text_exists(score, '{TITLE:') or text_exists(score, '{SUB-TITLE:') or text_exists(score, '{SUPER-TITLE:')
      creator_exists = text_exists(score, '{CREATOR:')
      if directive_exists or lcaption_exists or title_exists or creator_exists:
        return
      for noteObjects in voice.getElementsByTagName('noteObjects'):
        events = getElements(noteObjects, ['rest', 'chord'])
        index = 0
        for event in events:
          index += 1
          for text in event.getElementsByTagName('text'):
            content = getElement(text, 'content')
            if content and content.lastChild != None:
              ttext = latin1_e(content.lastChild.nodeValue)
              y = float(text.getAttribute('y'))
              if y > 0 or len(ttext) < 4 or ttext[0] == '{' or \
                 (isalpha(ttext[0]) and ttext[0] == ttext[0].lower()):
                continue
              if ttext in ['R.H.', 'R. H.', 'L.H.', 'L. H.']:
                continue
              font = getElement(text, 'font')
              if font.getAttribute('color') not in ['000000', None, '']:
                continue
              if font.getAttribute('face') == 'capella3':
                continue
              if index == 1 and ttext.lower().startswith('var'):
                content.lastChild.nodeValue = latin1_d('{LCAPTION:'+ttext+'}')
              elif _has_creator_prefix(ttext):
                content.lastChild.nodeValue = latin1_d('{CREATOR:'+ttext+'}')
              elif index == 1 and isalpha(ttext[0]) and '\n' not in ttext:
                content.lastChild.nodeValue = latin1_d('{DIRECTIVE:'+ttext+'}')
              elif re.search(r'\(\d\d\d\d\)', ttext):
                content.lastChild.nodeValue = latin1_d('{TITLE:'+ttext+'}')
              elif re.search(r'\d\d\d\d|(^| )[A-Z]\.|:', ttext):
                content.lastChild.nodeValue = latin1_d('{CREATOR:'+ttext+'}')
              elif re.match(r'\d+\. |[A-Z]\.', ttext):
                content.lastChild.nodeValue = latin1_d('{TITLE:'+ttext+'}')
              elif y < -7.5 and (len(ttext) >= 5 or ttext.upper() in ['CREDO']) and \
                   re.match(u'.*[A-ZÄÖÜ]', ttext):
                # Maß dafür, wie weit die Noten rechts stehen
                length1 = duration_sum(events[:index-1])
                length2 = duration_sum(events[index:])
                if length2 * 5 < length1:
                  content.lastChild.nodeValue = latin1_d('{CREATOR:'+ttext+'}')
                else:
                  content.lastChild.nodeValue = latin1_d('{TITLE:'+ttext+'}')
              elif index == 1 and isalpha(ttext[0]): # 11.5.15:40
                content.lastChild.nodeValue = latin1_d('{DIRECTIVE:'+ttext+'}')
              if y < -15:
                text.setAttribute('y', '-15.0')
        break
      break
    break

def set_command_font(font):
  setFont(font)
  font.setAttribute('face', commandFont)
  font.setAttribute('height', '9')
  font.setAttribute('charSet', '1')
  font.setAttribute('pitchAndFamily', '0')
  font.setAttribute('color', commandColor)
  font.setAttribute('underline', 'false')

def commands(score):
  # Befehle mit festen Parametern
  l = re.compile('^\s*\{\s*(((lyrics)?language|l?lang)\s*:\s*(en|de|es|fr|it|nl|dk|lt|any)|AT\s*:\s*(8|16|32|64))\s*\}\s*$', re.IGNORECASE)
  # Befehle ohne Parameter
  p = re.compile('^\s*\{\s*(s(p|v|)|piece|accordion|op|organ-pedals|catalyst|hide|(wind|plucking|string)(-instrument)?|guitar|violin|viola|cello|(double-)?bass|maxima|mxm|lunga|lng|brevis|brvs|whole|whl|ganze|3-dot|dot-3|nograce|sizes?-z|coincidence|join|gs|rh|lh|([rl]h:)?dir(ection)?:inv(erted)?|prime|o[ab](-[az])?|o-z|schleifer-[si]|[ln]?p|chordal|separated|vocal|(vocal-)?continues|solo-?part|vl-[az]|[ps]s|n[rs](-[az])?|cl2?-[az](:tr)?|cl?-[az]2?(:tr)?|w[<>][az]|\(?w[<>][az]\)?|\[?w[<>][az]\]?|AN|\(?AN\)?|\[?AN\]?)\s*\}\s*$', re.IGNORECASE)
  p_lsub = re.compile(r'^\s*\{\s*')
  p_rsub = re.compile(r'\s*\}\s*$')
  # Befehle ohne (variablen) Parameter, case sensitive
  P = re.compile('^\s*\{\s*(kk?|KK?)\s*\}\s*$')
  # Befehle ohne (variablen) Parameter, case insensitive, translate
  P2 = re.compile('^\s*\{\s*((r|l)h:(dir(ection)?:)?inv(erted)?)\s*\}\s*$', re.IGNORECASE)
  # Befehle mit einem Text-Parameter
  # directive=dir remark footnote=fnote=footn=fn instrument=i orchestration=o composer=komponist=creatorcreator lyrics ltext=ltxt metronome rhythm source=src rights register ending=volta playtime=play-time=duration range time text=txt title sub-title=subtitle=stitle supertitle=super-title caption lcaption variante=variant fine ataca=atacca=attaca=attacca
  q = re.compile('^\s*\{\s*(dir(ective)?|remark|f(oot)?n(ote)?|i(nstrument)?|o(rchestration)?|creator|composer|dedication|komponist|lyrics|lte?xt|metronome|rhythm|source|src|rights|register|ending|volta|duration|playtime|play-time|time|text|txt|publisher|range|r(ehearsal)?|title|s(ub-?)?title|super-?title|l?caption|variante?|fine|att?acc?a|h|hint|message|hinweis|prfm|performance|fnt)\s*:\s*.*?\s*\}\s*$', re.IGNORECASE | re.MULTILINE)
  # das gleiche aber medienspezifisch
  q2 = re.compile('^\s*[ailb]+\s*\{\s*(source|src|rights|title|s(ub-?)?title|super-?title|l?caption|hint|message|hinweis)\s*:\s*.*?\s*\}\s*$', re.IGNORECASE | re.MULTILINE)
  # Befehle mit einem Zahl-Parameter
  # section=s page=p lpage=lastpage=lastp=lp measurenumber=measure-number=mnr=m tuplet=triplet=x tuplets=triplets=xx foot-note-reference=footnote-reference=fnote-reference=fn-reference=foot-note-ref=footnote-ref=fnote-ref=fn-ref=fnr
  r = re.compile('^\s*\{\s*(s(ection)?|(l|last)?p(age)?|np|measure-?number|mnr|m|tuplets?|triplets?|xx?|f(oot)?-?n(ote)?-?r(ef(erence)?)?)\s*:\s*\d+\s*\}\s*$', re.IGNORECASE)
  # Befehle mit zwei Zahl-Parametern
  r2 = re.compile('^\s*\{\s*(s(ection)?)\s*:\s*\d+\s*:\s*\d+\s*\}\s*$', re.IGNORECASE)
  # Parameter, die später noch genauer ausgewertet werden sollten
  # ar bc stem size sr acc alter an moving=move
  s = re.compile('^\s*\{\s*(ar|bc|stem|size|sr|acc|alter|an|moving|move)\s*:\s*.*?\s*\}\s*$', re.IGNORECASE | re.MULTILINE)
  # Bogensymbole (rechts) {-}
  tr = re.compile('^\s*\{\s*(\s*_\s*([,;|/]| +))*\s*((\+?--?|-?-[12345]*|[vs]\+?--?|[vs]\+?\.\.?|\+?\.\.?|\.?~|-=)|\((\+?--?|-?-[12345]*|[vs]\+?--?|[vs]\+?\.\.?|\+?\.\.?|\.?~|-=)\)|\[(\+?--?|-?-[12345]*|[vs]\+?--?|[vs]\+?\.\.?|\+?\.\.?|\.?~|-=)\]|<-|\(?<-\)?|\[?<-\]?)\s*(\s*([,;|/]| +)\s*_)*\s*\}\s*$', re.IGNORECASE)
  tr2 = re.compile(r'\{(_[,;])*[vs]?=([,;]_)*\}')
  # Bogensymbole (links)
  tl = re.compile('^\s*\{\s*(\s*_\s*([,;|/]| +))*\s*((-?-[vs]|\.?\.[vs])|\((-?-[vs]|\.?\.[vs])\)|\[(-?-[vs]|\.?\.[vs])\]|<-|\(?<-\)?|\[?<-\]?)\s*(\s*([,;|/]| +)\s*_)*\s*\}\s*$', re.IGNORECASE)
  tl2 = re.compile(r'\{(_[,;])*=[vs]?([,;]_)*\}')
  # Haltebogensymbol
  tt = re.compile('^\s*\{\s*(:|::|=-|-=|:.|.:)\s*\}\s*$', re.IGNORECASE)
  # Haltebogensymbole, Stimmführungslinien
  u = re.compile('^\s*\{\s*((_|=|==|\-\\|\-/|\\\-|\-/)\s*[,;|/]\s*)*(=|==|\-\\|\-/|\\\-|\-/)\s*\}\s*$', re.IGNORECASE)
  u2 = re.compile('^\s*\{\s*\(\s*==?\s*\)\s*\}\s*$', re.IGNORECASE)
  left_curly_sub = re.compile(r'^\s*\{\s*')
  display_left_curly_sub = re.compile(r'^\s*[ailb]+\s*\{\s*', re.IGNORECASE)
  right_curly_sub = re.compile(r'\s*\}\s*$')
  qrs_command_sub = re.compile(r'^\s*[\w\d_-]+\s*:\s*')
  qrs_parameter_sub = re.compile(r'\s*:\s*.*$')
  tu_underscore_sub = re.compile(r'[ ,;|_]*$')
  tu_separator_sub = re.compile(r'\s*(\s*[,;|/]\s*| +)\s*')
  rehearsal_sub = re.compile(r'^\{>\w\}$')
  newline_resub = re.compile(r'###NEWLINE###', re.MULTILINE)
  # x = TEXTBLOCK
  x = re.compile(r'^\{\s*(TEXT-?BLOCK|T-?BLOCK|[Tt]ext-?[Bb]lock|t-?block)\s*:\s*(\d+)\s*:\s*(\d+)\s*:\s*(top|bottom|caption|creator|composer|super-?title|work-?title|sub-?title|title|copy?-rights|rights|source|src|notes|play-?time)\s*:')
  # y = Befehle die groß geschrieben werden sollen
  y = re.compile(r'^\{(TITLE|SUB-TITLE|SUPER-TITLE|L?P|VARIANT|CREATOR|DIR|FN):')
  # "Falsche Befehle"
  z = re.compile('^\s*\{.*\}\s*$', re.MULTILINE)
  for text in score.getElementsByTagName('text'):
    font = text.getElementsByTagName('font')[0]
    if font.getAttribute('color') in harmonyColors:
      continue
    content = getElement(text, 'content')
    if content.lastChild is None:
      continue
    dtext = latin1_e(content.lastChild.nodeValue)
    # Ersetze alle \n durch ###NEWLINE###
    dtext = dtext.strip().replace('\n', '###NEWLINE###')
    if l.match(dtext):
      ctext = _normalize_command(qrs_parameter_sub.sub('', right_curly_sub.sub('', left_curly_sub.sub('', dtext))).upper())
      ptext = qrs_command_sub.sub('', right_curly_sub.sub('', left_curly_sub.sub('', dtext)))
      text.setAttribute('align', 'left')
      set_command_font(font)
      dtext = '{' + ctext + ':' + ptext + '}'
      content.lastChild.nodeValue = latin1_d(dtext)
    elif rehearsal_sub.match(dtext):
      text.setAttribute('align', 'left')
      set_command_font(font)
      dtext = '{R:' + dtext[-2].upper() + '}'
      content.lastChild.nodeValue = latin1_d(dtext)
    elif p.match(dtext):
      dtext = _normalize_command(p_rsub.sub('', p_lsub.sub('', dtext)).upper())
      text.setAttribute('align', 'left')
      set_command_font(font)
      if dtext != 'P' and dtext != 'LP':
        text.setAttribute('x', '-1.5')
      dtext = '{' + dtext + '}'
      # Rekonstruiere ###NEWLINE### durch \n
      dtext = newline_resub.sub('\n', dtext, 100)
      content.lastChild.nodeValue = latin1_d(dtext)
    elif P.match(dtext):
      text.setAttribute('align', 'left')
      set_command_font(font)
    elif P2.match(dtext):
      ctext = _normalize_command(P2.sub('', right_curly_sub.sub('', left_curly_sub.sub('', dtext)))).upper()
      text.setAttribute('align', 'left')
      set_command_font(font)
      dtext = '{' + ctext + '}'
      content.lastChild.nodeValue = latin1_d(dtext)
    elif q.match(dtext) or r.match(dtext) or r2.match(dtext) or s.match(dtext):
      ctext = _normalize_command(qrs_parameter_sub.sub('', right_curly_sub.sub('', left_curly_sub.sub('', dtext))).upper())
      ptext = qrs_command_sub.sub('', right_curly_sub.sub('', left_curly_sub.sub('', dtext)))
      text.setAttribute('align', 'left')
      set_command_font(font)
      #if ctext != 'CREATOR' and ctext != 'LYRICS' and ctext != 'LTXT':
      #  text.setAttribute('x', '-1.5')
      dtext = '{' + ctext + ':' + ptext + '}'
      # Rekonstruiere ###NEWLINE### durch \n
      dtext = newline_resub.sub('\n', dtext, 100)
      content.lastChild.nodeValue = latin1_d(dtext)
      # wie q aber mit medienspezifisches Auszeichnung = display{command:text}
    elif q2.match(dtext):
      ddtext = dtext.replace(' ', '').lower()
      display = ''
      while len(ddtext) and ddtext[0] in ['a', 'i', 'l', 'b', 'A', 'I', 'L', 'B']:
        display += ddtext[0]
        ddtext = ddtext[1:]
      assert display != ''
      ctext = _normalize_command(qrs_parameter_sub.sub('', right_curly_sub.sub('', display_left_curly_sub.sub('', dtext))).upper())
      ptext = qrs_command_sub.sub('', right_curly_sub.sub('', display_left_curly_sub.sub('', dtext)))
      text.setAttribute('align', 'left')
      set_command_font(font)
      #if ctext != 'CREATOR' and ctext != 'LYRICS' and ctext != 'LTXT':
      #  text.setAttribute('x', '-1.5')
      dtext = display.lower() + '{' + ctext + ':' + ptext + '}'
      # Rekonstruiere ###NEWLINE### durch \n
      dtext = newline_resub.sub('\n', dtext, 100)
      content.lastChild.nodeValue = latin1_d(dtext)
    elif tr.match(dtext) or tr2.match(dtext): # Bindbögen rechts
      dtext = _normalize_command(tu_separator_sub.sub(',', tu_underscore_sub.sub('', right_curly_sub.sub('', left_curly_sub.sub('', dtext)))))
      text.setAttribute('align', 'left')
      text.setAttribute('x', '0.5')
      set_command_font(font)
      if dtext == '<-' or dtext == '(<-)' or dtext == '[<-]':
        font.setAttribute('color', '0000FE') # Phrasierungsbögen hellblau färben
      else:
        font.setAttribute('color', slurColor)
      dtext = '{' + dtext + '}'
      # Rekonstruiere ###NEWLINE### durch \n
      dtext = newline_resub.sub('\n', dtext, 100)
      content.lastChild.nodeValue = latin1_d(dtext)
    elif tl.match(dtext) or tl2.match(dtext): # Bindbögen links
      dtext = _normalize_command(tu_separator_sub.sub(',', tu_underscore_sub.sub('', right_curly_sub.sub('', left_curly_sub.sub('', dtext)))))
      text.setAttribute('align', 'right')
      text.setAttribute('x', '1.0')
      set_command_font(font)
      if dtext == '->' or dtext == '(->)' or dtext == '[->]':
        font.setAttribute('color', '0000FE') # Phrasierungsbögen hellblau färben
      else:
        font.setAttribute('color', slurColor)
      dtext = '{' + dtext + '}'
      # Rekonstruiere ###NEWLINE### durch \n
      dtext = newline_resub.sub('\n', dtext, 100)
      content.lastChild.nodeValue = latin1_d(dtext)
    elif tt.match(dtext): # Haltebogensymbol
      font.setAttribute('color', '0000FE')
    elif u.match(dtext):  # Haltebögen
      dtext = _normalize_command(tu_separator_sub.sub(',', tu_underscore_sub.sub('', right_curly_sub.sub('', left_curly_sub.sub('', dtext)))))
      #text.setAttribute('align', 'right')
      text.setAttribute('x', '1.0')
      set_command_font(font)
      if dtext == '->' or dtext == '(->)' or dtext == '[->]':
        font.setAttribute('color', '0000FE')
      else:
        font.setAttribute('color', slurColor)
      dtext = '{' + dtext + '}'
      # Rekonstruiere ###NEWLINE### durch \n
      dtext = newline_resub.sub('\n', dtext, 100)
      content.lastChild.nodeValue = latin1_d(dtext)
    elif u2.match(dtext):  # Haltebögen in Klammern
      text.setAttribute('x', '1.0')
      set_command_font(font)
      font.setAttribute('color', slurColor)
    elif x.match(dtext):
      text.setAttribute('align', 'left')
      set_command_font(font)
      text.setAttribute('x', '-1.5')
    elif z.match(dtext):
      text.setAttribute('align', 'left')
      set_command_font(font)
      font.setAttribute('color', errorColor)
      font.setAttribute('underline', 'true')
      text.setAttribute('x', '-1.5')
    if y.match(dtext):
      font.setAttribute('height', '12')

###############################################################################

def _looks_like_fine(ttext, score):
  if ttext.startswith('{'): return False
  if ttext.startswith('zu '): return True
  if ttext.startswith('DC.'): return True
  if 'Ende' in ttext: return True
  return False
  
########################################
  
# 1. Taktstriche wie :|| am Anfang und ||: am Ende der Zeile markieren
# 2. Texte die an Taktstriche gebunden sind, einfärben
# 3. Unter Umständen Texte in FINE: umwandeln
# 4. Einfache Taktstriche mit Warnfarbe versehen
def barlines(score):
  for noteObjects in score.getElementsByTagName('noteObjects'):
    index = 0
    lastnode = 0
    for no in noteObjects.childNodes:
      if no.nodeType == no.ELEMENT_NODE:
        index += 1
        lastnode = no
        if index == 1 and latin1_e(no.tagName) in ['barline'] and (no.getAttribute('type') in ['end', 'repEnd', 'repEndBegin', 'double', 'normal', 'dashed'] or len(no.getAttribute('type')) == 0):
          no.setAttribute('color', errorColor)
    if index > 1 and lastnode.nodeType == lastnode.ELEMENT_NODE and latin1_e(lastnode.tagName) in ['barline'] and lastnode.getAttribute('type') in ['repBegin', 'repEndBegin']:
      lastnode.setAttribute('color', errorColor)
  for barline in score.getElementsByTagName('barline'):
    for text in barline.getElementsByTagName('text'):
      font = getElement(text, 'font')
      content = getElement(text, 'content')
      ttext = latin1_e(content.lastChild.nodeValue)
      if font.getAttribute('face').startswith('capella'):
        if ttext not in ['y', 'n', 'o', 'd', 'e', 'k', 'u']: # coda segno
          font.setAttribute('color', hintColor)
      else:
        if barline.getAttribute('type') in ['repEnd', 'double', 'end'] and \
           not ttext.lstrip().startswith('{'):
          for c in ttext:
            if isalpha(c):
              content.lastChild.nodeValue = '{FINE:'+ttext+'}'
              set_command_font(font)
              font.setAttribute('color', hintColor)
              break
  for barline in score.getElementsByTagName('barline'):
    if barline.getAttribute('type') not in ['repEnd', 'repEndBegin', 'repBegin', 'double', 'end', 'dashed']:
      barline.setAttribute('color', hintColor)
  if first_call(score):
    for text in score.getElementsByTagName('text'):
      content = getElement(text, 'content')
      ttext = latin1_e(content.lastChild.nodeValue)
      if _looks_like_fine(ttext, score):
        font = getElement(text, 'font')
        content.lastChild.nodeValue = '{FINE:'+ttext+'}'
        set_command_font(font)
        font.setAttribute('color', hintColor)


def _issubset(pitches1, pitches2):
  for p in pitches1:
    if p not in pitches2:
      return False
  return True

# single standing tie to {=}
def repair_ties(score):
  doc = score.parentNode
  # Haltebögen die in anderer Stimme enden unterdrücken
  for noteObjects in score.getElementsByTagName('noteObjects'):
    notesrests = getElements(noteObjects, ['chord', 'rest'])
    for i in range(len(notesrests)-1):
      chord = notesrests[i]
      if chord.nodeName == 'chord':
        next = notesrests[i+1]
        chordheads = chord.getElementsByTagName('head')
        if len(chordheads) == 1:
          for chordhead in chord.getElementsByTagName('head'):
            pitch = latin1_e(chordhead.getAttribute('pitch'))
            for tie in chordhead.getElementsByTagName('tie'):
              if tie.hasAttribute('begin') and tie.getAttribute('begin') == 'true':
                tiecorrect = 0
                if next.nodeName == 'chord':
                  for nexthead in next.getElementsByTagName('head'):
                    nextpitch = latin1_e(nexthead.getAttribute('pitch'))
                    if nextpitch == pitch:
                      tiecorrect = 1
                # Entferne tie und schreibe {=}
                if tiecorrect == 0:
                  chordhead.removeChild(tie)
                  drawObjects = createNewChild(chord, 'drawObjects')
                  drawObj = createNewChild(drawObjects, 'drawObj', True)
                  text = createNewChild(drawObj, 'text', attrib={'x':'0.0', 'y':'1.0'})
                  font = createNewChild(text, 'font', True)
                  setFont(font)
                  font.setAttribute('face', commandFont)
                  font.setAttribute('height', '12')
                  font.setAttribute('charSet', '1')
                  font.setAttribute('pitchAndFamily', '0')
                  content = createNewChild(text, 'content', True)
                  content.appendChild(doc.createTextNode(latin1_d('{=}')))
  # Falls Akkord mit Haltebögen und nur Teil der Bögen gültig so schreibe {_, =} etc.
  for noteObjects in score.getElementsByTagName('noteObjects'):
    # barline: respect endings
    notesrests = getElements(noteObjects, ['chord', 'rest', 'barline'])
    for i in range(len(notesrests)-1):
      chord1 = notesrests[i]
      chord2 = notesrests[i+1]
      if chord1.tagName == 'chord' and chord2.tagName == 'chord':
        ties1_start = [tie for tie in chord1.getElementsByTagName('tie') if tie.getAttribute('begin') == 'true']
        ties2_stop = [tie for tie in chord2.getElementsByTagName('tie') if tie.getAttribute('end') == 'true']
        if len(ties1_start) and len(ties2_stop):
          pitches1 = [n.getAttribute('pitch') for n in chord1.getElementsByTagName('head')]
          pitches2 = [n.getAttribute('pitch') for n in chord2.getElementsByTagName('head')]
          # > 1 : no need for one single note, 19/3/27 12:54
          if len(pitches1) > 1 and not _issubset(pitches1, pitches2):
            # delete ties
            for head in chord1.getElementsByTagName('head'):
              for tie in head.getElementsByTagName('tie'):
                if tie.getAttribute('begin') == 'true':
                  if tie.getAttribute('end') == 'true':
                    tie.setAttribute('begin', 'false')
                  else:
                    head.removeChild(tie)
            for head in chord2.getElementsByTagName('head'):
              for tie in head.getElementsByTagName('tie'):
                if tie.getAttribute('end') == 'true':
                  if tie.getAttribute('begin') == 'true':
                    tie.setAttribute('end', 'false')
                  else:
                    head.removeChild(tie)
            ties = []
            for pitch in pitches1:
              if pitch in pitches2:
                ties.insert(0, '=')
              else:
                ties.insert(0, '_')
            while len(ties) and ties[-1] == '_':
              ties.remove(ties[-1])
            if len(ties):
              tie_text = '{'+','.join(ties)+'}'
              drawObjects = createNewChild(chord1, 'drawObjects')
              drawObj = createNewChild(drawObjects, 'drawObj', True)
              text = createNewChild(drawObj, 'text')
              text.setAttribute('x', '-3.8')
              text.setAttribute('y', '-3.5')
              font = createNewChild(text, 'font')
              setFont(font)
              content = createNewChild(text, 'content')
              setText(content, tie_text)

# Am Zeilenübergang Ties in Slurs umwandeln
def ties_to_slurs(score):
  systems = score.getElementsByTagName('system')
  for system_i in range(0, len(systems)-1):
    system1 = systems[system_i]
    system2 = systems[system_i+1]
    staffs1 = system1.getElementsByTagName('staff')
    staffs2 = system2.getElementsByTagName('staff')
    if len(staffs1) == len(staffs2):
      for staff1_i in range(0, len(staffs1)):
        for staff2_i in range(0, len(staffs2)):
          if staff1_i == staff2_i:
            staff1 = staffs1[staff1_i]
            staff2 = staffs2[staff2_i]
            voices1 = staff1.getElementsByTagName('voice')
            voices2 = staff2.getElementsByTagName('voice')
            if len(voices1) == 1 and len(voices2) == 1:
              noteObjects1 = voices1[0].getElementsByTagName('noteObjects')[0]
              noteObjects2 = voices2[0].getElementsByTagName('noteObjects')[0]
              events1 = getElements(noteObjects1, ['rest', 'chord'])
              events2 = getElements(noteObjects2, ['rest', 'chord'])
              if len(events1) and len(events2) and events1[-1].nodeName == 'chord' and \
                 events2[0].nodeName == 'chord':
                chord1 = events1[-1]
                chord2 = events2[0]
                heads1 = chord1.getElementsByTagName('head')
                heads2 = chord2.getElementsByTagName('head')
                if len(heads1) == 1 and len(heads2) == 1:
                  head1 = heads1[0]
                  head2 = heads2[0]
                  if head1.getAttribute('pitch') != head2.getAttribute('pitch'): # TODO hier alter vergleichen
                    ties1 = head1.getElementsByTagName('tie')
                    ties2 = head2.getElementsByTagName('tie')
                    if len(ties1) == 1 and len(ties2) == 1:
                      tie1 = ties1[0]
                      tie2 = ties2[0]
                      if tie1.getAttribute('begin') == 'true' and tie2.getAttribute('end') == 'true':                
                        head1.removeChild(tie1)
                        head2.removeChild(tie2)
                        # erster Bogen
                        drawObjects1 = createNewChild(chord1, 'drawObjects')
                        drawObj1 = createNewChild(drawObjects1, 'drawObj', True)
                        slur1 = createNewChild(drawObj1, 'slur')
                        setAttributes(slur1, {'x1': 0.66, 'y1': -2.69, 'x2' : 1.34, 'y2' : -3.44, 'x3' : 5.28, 'y3' : -3.38, 'x4' : 6.03, 'y4' : -3.06, 'color' : harmonyColor})
                        basic1 = createNewChild(drawObj1, 'basic')
                        basic1.setAttribute('noAdjust', 'true')
                        # zweiter Bogen
                        drawObjects2 = createNewChild(chord2, 'drawObjects')
                        drawObj2 = createNewChild(drawObjects2, 'drawObj', True)
                        slur2 = createNewChild(drawObj2, 'slur')
                        setAttributes(slur2, {'x1': -2.8, 'y1': -3.7, 'x2' : -2.1, 'y2' : -4.7, 'x3' : 0.5, 'y3' : -5.2, 'x4' : 1.8, 'y4' : -3.7, 'color' : harmonyColor})
                        basic2 = createNewChild(drawObj2, 'basic')
                        basic2.setAttribute('noAdjust', 'true')

#TODO not linked
def beats_keys_errors(score):
  for tag in ['keySign', 'timeSign']:
    for system in score.getElementsByTagName('system'):
      base = None
      for voice in system.getElementsByTagName('voice'):
        current = []
        for keyTime in voice.getElementsByTagName(tag):
          if tag == 'keySign':
            current.append(keyTime.getAttribute('fifths'))
          elif tag == 'timeSign':
            current.append(keyTime.getAttribute('time'))
        if base == None:
          base = current
        if base != current:
          for keyTime in system.getElementsByTagName(tag):
            keyTime.setAttribute('color', errorColor)

# Färbe künstliche Pausen ein, wenn für den Rhythmus untypisch
def beats_rests_errors(score):
  conflicts = [('9/8', '1/2', '0'), ('6/8', '1/2', '0'), ('6/8', '1/4', '0')]
  oldTimeSign = None
  timeSign = None
  for system in score.getElementsByTagName('system'):
    oldTimeSign = timeSign
    for staff in system.getElementsByTagName('staff'):
      if staff.getAttribute('defaultTime') != None:
        timeSign = staff.getAttribute('defaultTime')
      else:
        timeSign = oldTimeSign
      for noteObjects in staff.getElementsByTagName('noteObjects'):
        timeSigns_rests = getElements(noteObjects, ['timeSign', 'rest'])
        for tsr in timeSigns_rests:
          if tsr.tagName == 'timeSign':
            timeSign = tsr.getAttribute('time')
          elif tsr.tagName == 'rest' and not getElement(tsr, 'tuplet'):
            duration = getElement(tsr, 'duration')
            base = duration.getAttribute('base')
            dots = duration.getAttribute('dots')
            if dots == None or dots.strip() == '': dots = '0'
            if (timeSign, base, dots) in conflicts or dots == '1/2':
              display = getElement(tsr, 'display')
              if display and display.getAttribute('invisible') == 'true':
                set_chord_rest_color(tsr, errorColorI)
                display.setAttribute('invisible', 'false')


def check_alternation(score):
  for noteObjects in score.getElementsByTagName('noteObjects'):
    events = getElements(noteObjects, ['rest', 'chord', 'barline'])
    i = 0
    while i < len(events)-1:
      event1 = events[i]
      event2 = events[i+1]
      if latin1_e(event1.nodeName) == 'chord' and latin1_e(event2.nodeName) == 'chord':
        for text in event1.getElementsByTagName('text'):
          content = getElement(text, 'content')
          ttext = latin1_e(content.lastChild.nodeValue)
          if ttext.startswith('{AT:'):
            duration = getElement(event2, 'duration')
            if duration.getAttribute('noDuration') != 'true':
              for font in text.getElementsByTagName('font'):
                font.setAttribute('color', errorColor)
      i += 1

# Akzente wie sf usw rot färben, wenn die an einer Pause stehen
def accent_check(score):
  for rest in score.getElementsByTagName('rest'):
    for text in rest.getElementsByTagName('text'):
      content = getElement(text, 'content')
      if content.lastChild == None:
        continue
      dtext = latin1_e(content.lastChild.nodeValue)
      font = getElement(text, 'font')
      if (font.getAttribute('face') == 'capella3' and dtext in ['s', 'zS', '{']) or \
         dtext in ['sf', 'sff', 'rfz', 'rffz', 'sfz', 'sffz', 'rf', 'rff']:
        set_chord_rest_color(rest, errorColor)
        #TODO text unterstreichen

def word_min_size(score):
  for text in score.getElementsByTagName('text'):
    font = getElement(text, 'font')
    height = latin1_e(font.getAttribute('height'))
    if len(height) == 1 or height in ['10', '11']:
      font.setAttribute('height', '12')

# Fingersätze blau färben und in der Größe anpassen
def string_fingering(score):
  p = re.compile('^((\\.\\.|--)?[012345](\\.\\.|--|-)?|\\([012345]\\)|\\[[012345]\\])?$')
  q = re.compile('^[012345]-[012345]$')
  for staff in score.getElementsByTagName('staff'):
    for text in staff.getElementsByTagName('text'):
      content = getElement(text, 'content')
      if content and content.lastChild != None:
        ttext = latin1_e(content.lastChild.nodeValue)
        font = getElement(text, 'font')
        for reg in [p, q]:
          if reg.match(ttext) and int(font.getAttribute('height')) < 15:
            setFont(font, bold=True)
            font.setAttribute('color', '0000FE')
            font.setAttribute('height', '10')
            font.setAttribute('face', cypherFont)
            text.setAttribute('x', '0.0')
            y = float(text.getAttribute('y'))
            text.setAttribute('y', "%f" % (round(y * 2) / 2))

# Lagen blau färben und Größe anpassen
def string_mark_positions(score):
  p = re.compile('^-?p(1|2|3|4|5|6|7|8|9|10|11|12)(\\.\\.|--)?$')
  for text in score.getElementsByTagName('text'):
    content = getElement(text, 'content')
    if content and content.lastChild != None:
      ttext = latin1_e(content.lastChild.nodeValue)
      if p.match(ttext):
        font = getElement(text, 'font')
        setFont(font, bold=True)
        font.setAttribute('color', '0000FE')
        font.setAttribute('height', '15')
        font.setAttribute('face', cypherFont)
        text.setAttribute('x', '0.0')

# Saiten pink färben und Größe anpassen
def string_mark_strings(score):
  p = re.compile('^((I|II|III|IV|sV|sVI|sVII)(\\.\\.|--)?)$')
  for text in score.getElementsByTagName('text'):
    content = getElement(text, 'content')
    if content and content.lastChild != None:
      ttext = latin1_e(content.lastChild.nodeValue)
      if p.match(ttext):
        font = getElement(text, 'font')
        setFont(font, bold=True)
        font.setAttribute('color', 'FE00FE')
        font.setAttribute('height', '15')
        font.setAttribute('face', cypherFont)
        text.setAttribute('x', '0.0')

# Saiten/Lagenangaben an Pausen rot färben
def string_mark_rests(score):
  p = re.compile('^(o|O|v|V)?$')
  q = re.compile('^(Y|Z)?$')
  for text in score.getElementsByTagName('text'):
    font = getElement(text, 'font')
    content = getElement(text, 'content')
    if content and content.lastChild != None:
      ttext = latin1_e(content.lastChild.nodeValue)
      if p.match(ttext) and font.getAttribute('face') != 'capella3':
        font = getElement(text, 'font')
        setFont(font, bold=True)
        font.setAttribute('color', slurColor)
        font.setAttribute('height', '12')
        font.setAttribute('face', 'Times New Roman')
        text.setAttribute('x', '0.0')
      if q.match(ttext) and font.getAttribute('face') == 'capella3':
        font = getElement(text, 'font')
        setFont(font, bold=True)
        font.setAttribute('color', slurColor)
        font.setAttribute('height', '15')
        text.setAttribute('x', '0.0')

# Eintrag {violin} für alle Systeme erzeugen, Gitarre 1, Gitarre 2, ... eintragen, wenn mehr als ein System
def mark_violin(score):
  doc = score.parentNode
  # Feststellen, ob {q} schon existiert
  p = re.compile('^\s*\{\s*VIOLIN\s*\}\s*$', re.I)
  guitar_nexists = 1
  for content in score.getElementsByTagName('content'):
    if content.lastChild is None:
      continue
    ctext = latin1_e(content.lastChild.nodeValue)
    if p.search(ctext):
      guitar_nexists = 0
  # guitar_nexists = 1 => überall {GUITAR} einfügen
  if guitar_nexists == 1:
    for system in score.getElementsByTagName('system'):
      for staff in system.getElementsByTagName('staff'):
        for noteObjects in staff.getElementsByTagName('noteObjects'):
          events = getElements(noteObjects, ['rest', 'chord'])
          for event in events:
            drawObjects = getElement(event, 'drawObjects')
            if not drawObjects:
              drawObjects = createNewChild(event, 'drawObjects')
            drawObj = createNewChild(drawObjects, 'drawObj', True)
            text = createNewChild(drawObj, 'text', attrib={'x':'-3.8', 'y':'-3.5'})
            font = createNewChild(text, 'font')
            setFont(font)
            font.setAttribute('face', commandFont)
            font.setAttribute('height', '12')
            font.setAttribute('pitchAndFamily', '0')
            content = createNewChild(text, 'content')
            content.appendChild(doc.createTextNode('{VIOLIN}'))
            break
          break
      break
  # Mehr als ein System => Violine 1, Violine 2 einfügen
  inames_count = 0
  # Standardname unbekannt... ist voreingestellt
  standard_names = True
  p = re.compile('^unbenannt\d*$')
  descriptions = {}
  for staffLayout in score.getElementsByTagName('staffLayout'):
    inames_count += 1
    description = staffLayout.getAttribute('description')
    if not p.search(latin1_e(description)):
      standard_names = False
  if inames_count > 1 and standard_names:  # > 1 => Benennung nur ab zwei Systemen aufwärts
    i = 1
    for staffLayout in score.getElementsByTagName('staffLayout'):
      description = staffLayout.getAttribute('description')
      descriptions[latin1_e(description)] = 'Violine '+str(i)
      staffLayout.setAttribute('description', 'Violine '+str(i))
      for instrument in staffLayout.getElementsByTagName('instrument'):
        instrument.setAttribute('name', 'Violine '+str(i))
        instrument.setAttribute('abbrev', 'Viol. '+str(i))
      i += 1
    i = 1
    for system in score.getElementsByTagName('system'):
      for staff in system.getElementsByTagName('staff'):
        description = staff.getAttribute('layout')
        staff.setAttribute('layout', descriptions[latin1_e(description)])
    for system in score.getElementsByTagName('system'):
      system.setAttribute('instrNotation', 'long')
      break

# Saiten blau färben und Größe anpassen
def plucking_mark_strings(score):
  p = re.compile('^([sS][1234567](\\.\\.|--)?)$')
  for text in score.getElementsByTagName('text'):
    content = getElement(text, 'content')
    if content and content.lastChild != None:
      ttext = latin1_e(content.lastChild.nodeValue)
      if p.match(ttext):
        font = getElement(text, 'font')
        setFont(font, bold=True)
        if font.getAttribute('color') != errorColor:
          font.setAttribute('color', '0000FE')
        font.setAttribute('height', '15')
        font.setAttribute('face', cypherFont)
        text.setAttribute('x', '0.0')
        content.lastChild.nodeValue = latin1_d(ttext.lower())

def solo_tutti(score):
  for text in score.getElementsByTagName('text'):
    content = getElement(text, 'content')
    if content.lastChild is None:
      continue
    dtext = latin1_e(content.lastChild.nodeValue)
    if dtext in ['solo', 'Solo', 'tutti', 'Tutti']:
      font = getElement(text, 'font')
      setFont(font, bold=True)
      font.setAttribute('height', '12')
      font.setAttribute('color', 'FE00FE')
      font.setAttribute('face', 'Times New Roman')
      font.setAttribute('italic', 'true') # TODO set color font


def optimize_lyrics(score):
  blue_lyrics(score)
  lyrical_accidentals(score)
  lyrical_extenders(score)
  dot_verses(score) # a . tem => a - tem
  minus_verses(score) # Markieren falls \- steht
  majuscle_verses(score)
  kk_verses(score)
  verse_errors(score)
  space_verses(score) # do ar versus cru doar
  non_splitted(score) # grambo statt gram-bo
  non_bind(score)
  rare_verses(score)
  verse_numbers(score) # stanza
  
#TODO not bound
def additional_checks(score):
  dot_check(score)
  accent_check(score) # TODO sehr langsam


# entferne Triolenbögen
def remove_xplet_slurs(score):
  return
  if not first_call():
    return
  for chord in score.getElementsByTagName('chord'):
    duration = getElement(chord, 'duration')
    tuplet = getElement(duration, 'tuplet')
    if tuplet:
      count = int(tuplet.getAttribute('count'))
      drawObjects = getElement(chord, 'drawObjects')
      if drawObjects:
        for drawObj in drawObjects.getElementsByTagName('drawObj'):
          slur = getElement(drawObj, 'slur')
          if slur:
            basic = getElement(drawObj, 'basic')
            if basic:
              noteRange = int(basic.getAttribute('noteRange'))
              if noteRange == count-1:
                drawObjects.removeChild(drawObj)


# rec b:sfz (sfz braille only)
mdyn = re.compile(r'b\s*:\s*(\(|\[|)\s*(p{1,6}|f{1,6}|spp?|sff?z|sfpp?|sff?|rfz?|mp|mf|ff?z|fp)\s*(\)|\]|)\s*')
def mediaspecific_dynamics(score):
  for text in score.getElementsByTagName('text'):
    content = getElement(text, 'content')
    if content.lastChild is None:
      continue
    dtext = latin1_e(content.lastChild.nodeValue)
    if mdyn.match(dtext):
      font = getElement(text, 'font')
      if not font:
        font = createNewChild(text, 'font')
      font.setAttribute('height', '12')
      font.setAttribute('weight', '700')
      font.setAttribute('face', 'Times New Roman')
      font.setAttribute('italic', 'true')


def lyrics_artificial_dynamics(score):
  for staff in score.getElementsByTagName('staff'):
    if len(staff.getElementsByTagName('lyric')):
      i = 0
      for voice in staff.getElementsByTagName('voice'):
        i += 1
        if voice > 1  and len(voice.getElementsByTagName('chord')) == 0:
          for rest in voice.getElementsByTagName('rest'):
            found = False
            for drawObj in rest.getElementsByTagName('drawObj'):
              for wedge in drawObj.getElementsByTagName('wedge'):
                y = float(wedge.getAttribute('y1'))
                if y < 0:
                  wedge.setAttribute('color', '555522')
                  found = True
              for text in drawObj.getElementsByTagName('text'):
                if getText(getElement(text, 'content')) in ['f', 'g', 'h', 'i', 'j', 'p', 'q', 'r', 's', 'u', 'z', '|', '{']:
                  font = getElement(text, 'font')
                  if font:
                    font.setAttribute('color', '555522')
                    found = True
            display = getElement(rest, 'display')
            if not display:
              display = createNewChild(rest, 'display')
            if found:
              display.setAttribute('invisible', 'false')
              display.setAttribute('color', '808080')
            elif display.getAttribute('color') in [None, '', '000000']:
              display.setAttribute('invisible', 'true')


# Landscape einstellen, wenn zur viele Silben oder zu viele Noten
def landscape(score):
  if not first_call(score): return
  pages = score.getElementsByTagName('pages')
  if len(pages) == 1:
    if pages[0].getAttribute('landscape') == 'true':
      return False
    # MM 14.03.2018 12:17
    for staffs in score.getElementsByTagName('staves'):
      if len(staffs.getElementsByTagName('staff')) > 6:
        return
    for voice in score.getElementsByTagName('voice'):
      verses = [latin1_e(verse.lastChild.nodeValue) for verse in voice.getElementsByTagName('verse') if verse.getAttribute('i') == '0' and verse.lastChild != None]
      # 60: MM 14.03.2018 12:17
      # 66: MM 03.09.2018 10:17
      if len(' '.join(verses)) > 70:
        pages[0].setAttribute('landscape', 'true')
        return
      if len(voice.getElementsByTagName('chord')) > 50:
        pages[0].setAttribute('landscape', 'true')
        return
        
def staccato_to_articulation(score):
  """DrawObj - Staccato als <articulation> setzen
  """
  replace_count = 0
  for chord in score.getElementsByTagName('chord'):
    drawObjects = firstChildElement(chord,'drawObjects')
    if drawObjects:
      for drawObj in drawObjects.getElementsByTagName('drawObj'):
        text = firstChildElement(drawObj, 'text')
        if text:
          content_el = firstChildElement(text, 'content')
          content = content_el.firstChild.nodeValue #.encode('Latin-1')
          y = float(text.getAttribute('y'))
          x = float(text.getAttribute('x'))
          #result of 'bla'.decode() is a unicode string
          if content == '\xb4'.decode('Latin-1'): #TODO: "handgemachte" Staccatopunkte, Verlängerungspunkt
            articulation = firstChildElement(chord, 'articulation')
            if articulation:
              art_type = articulation.getAttribute('type')
              sym = ''
              if art_type == 'staccatissimo': 
                if y>0: sym='\xCE'
                else: sym='\xC9'
              elif art_type == 'normalAccent': sym='\xCA'
              elif art_type == 'tenuto': sym='\xC8'
              elif art_type == 'strongAccent': sym='\xCB'
              elif art_type == 'weakBeat': sym='\xCC'
              elif art_type == 'strongBeat': 
                if y>0: sym='\xCF'
                else: sym='\xCD'
              if art_type == 'staccato tenuto':
                pass
              elif art_type in ('staccatissimo'):
                if y>0: sym='\xCE'
                else: sym='\xC9'
              dy = 3
              dx = -0.3
              if sym>'':
                if y!=0: y = y + dy/y
                else: y=-2.5
                x = x + dx 
                text.setAttribute('y', str(y))
                text.setAttribute('x', str(x))
                # messageBox('Staccato', content) #hex(ord(content))
                content_el.firstChild.replaceWholeText(sym.decode('Latin-1')) #.encode('Latin-1')
                articulation.setAttribute('type','staccato')
                replace_count += 1
              else:
                pass
                # messageBox('Fehler:', 'Staccato bereits vorhanden oder unbekanntes articulation Element: '+str(art_type))  

            else: #if chord has no articulation element, create and append one
              doc = xml.dom.minidom.parseString('<score/>')
              articulation = doc.createElement('articulation')
              articulation.setAttribute('type','staccato')
              chord.appendChild(articulation)
              drawObjects.removeChild(drawObj) #(Elternknoten) <drawobjects> wird von Capella beräumt

def clefs(score):
  for clefSign in score.getElementsByTagName('clefSign'):
    clef = clefSign.getAttribute('clef')
    for prefix in ['G1', 'G3', 'G4', 'G5', 'F1', 'F2', 'F3', 'F5']:
      if clef.startswith(prefix):
        clefSign.setAttribute('color', errorColor)
      elif clef[-1] in ['+', '-']:
        clefSign.setAttribute('color', errorColor2)

# color rest in red if only real on in system
# Mark artifical rests if single standing and invisible and tuplet
def rhythm_hints(score):
  doc = score.parentNode
  global messages
  for voice in score.getElementsByTagName('voice'):
    if len(voice.getElementsByTagName('chord')):
      continue
    normal_seen = False
    artificial_seen = False
    for rest in voice.getElementsByTagName('rest'):
      display = getElement(rest, 'display')
      if display and display.getAttribute('invisible') == 'true':
        artificial_seen = True
      else:
        normal_seen = True
    if normal_seen and artificial_seen:
      for rest in voice.getElementsByTagName('rest'):
        display = getElement(rest, 'display')
        if display and display.getAttribute('invisible') == 'true':
          continue
        elif display and display.getAttribute('invisible') != 'true':
          display.setAttribute('color', errorColor)
        elif not display:
          display = createNewChild(rest, 'display')
          display.setAttribute('color', errorColor)
  def _has_tuplet(event):
    return getElement(event, 'duration', 'tuplet')
  def _mark_system(first_event):
    not_exists = True
    for content in first_event.getElementsByTagName('content'):
      if content.lastChild != None and latin1_e(content.lastChild.nodeValue).startswith('$'):
        content.lastChild.nodeValue = latin1_d('$'+str(system_i+1))
        not_exists = False
    if not_exists:
      drawObjects = getElement(first_event, 'drawObjects')
      if not drawObjects:
        drawObjects = createNewChild(first_event, 'drawObjects')
      drawObj = createNewChild(drawObjects, 'drawObj', new=True)
      text = createNewChild(drawObj, 'text', attrib={'x':'-16.0', 'y':'-5.0'})
      content = createNewChild(text, 'content')
      content.appendChild(doc.createTextNode(latin1_d('$'+str(system_i+1))))
      font = createNewChild(text, 'font', attrib={'face':commandFont, 'height':'16', 'color':hintColor, 'weight':'200'})
  for system_i, system in enumerate(score.getElementsByTagName('system')):
    for noteObjects in system.getElementsByTagName('noteObjects'):
      show = True
      events = getElements(noteObjects, ['rest', 'chord'])
      i = 0
      while i < len(events)-1:
        display = getElement(events[i], 'display')
        # Mark artifical rests/notes if single standing and invisible and tuplet
        if _has_tuplet(events[i]):
          if i == 0 or not _has_tuplet(events[i-1]):
            if i == len(events)-1 or not _has_tuplet(events[i+1]):
              if not display:
                display = createNewChild(events[i], 'display')
              display.setAttribute('color', errorColor)
              display.setAttribute('invisible', 'false')
              add_message('tuplet_rest', system_i=system_i)
              if show:
                _mark_system(events[0])
                show = False
        # Mark artifical rests if invisible and tuplet and surrounded by tuplet notes
        if _has_tuplet(events[i]) and events[i].nodeName == 'rest':
          if i > 0 and i < len(events)-1 and \
             events[i-1].nodeName == 'chord' and events[i+1].nodeName == 'chord' and \
             _has_tuplet(events[i-1]) and _has_tuplet(events[i+1]):
            if not display:
              display = createNewChild(events[i], 'display')
            display.setAttribute('color', errorColor)
            display.setAttribute('invisible', 'false')
            add_message('tuplet_rest', system_i=system_i)
            if show:
              _mark_system(events[0])
              show = False
        i += 1

# Texte in zweiter Stimme mit Text => markieren = capella-scan-Fehler
def rests_texts(score):
  for staff in score.getElementsByTagName('staff'):
    voice_i = 0
    for voice in staff.getElementsByTagName('voice'):
      voice_i += 1
      if voice_i > 1:
        for rest in voice.getElementsByTagName('rest'):
          for verticalPos in rest.getElementsByTagName('verticalPos'):
            if verticalPos.getAttribute('centered') == 'true':
              for text in rest.getElementsByTagName('text'):
                text.setAttribute('x', str(float(text.getAttribute('x'))+1.0))
                text.setAttribute('y', str(float(text.getAttribute('y'))+2.0))
                for font in text.getElementsByTagName('font'):
                  font.setAttribute('color', errorColor)

def page_size(score):
  pages = getElement(score, 'layout', 'pages')
  try: paperSizeX = round(pages.getAttribute('paperSizeX'))
  except: paperSizeX = 210
  try: paperSizeY = round(pages.getAttribute('paperSizeY'))
  except: paperSizeY = 297
  if pages:
    staff_count = 0
    for system in score.getElementsByTagName('system'):
      staff_count = max(staff_count, len(system.getElementsByTagName('staff')))
    if staff_count > 6:
      paperSizeY = max(paperSizeY, staff_count*38)
      paperSizeX = max(paperSizeX, min(round(float(paperSizeY)/1.6), 350))
      pages.setAttribute('paperSizeX', str(paperSizeX))
      pages.setAttribute('paperSizeY', str(paperSizeY))
      try: pages.removeAttribute('paperSize')
      except: pass


def show_barnumbers(score):
  if getElement(score, 'barCount'):
    return
  barCount = createNewChild(score, 'barCount', attrib={'x':'-2', 'y':'3.5'})
  font = createNewChild(barCount, 'font', attrib={'face':'Verdana', 'height':'12'})


# Fingersätze blau färben und in der Größe anpassen
# pulgar usw. pink färben
def guitar_fingering(score):
  def _set_attribute(font, color):
    font.setAttribute('color', color)
    font.setAttribute('height', '10')
    font.setAttribute('face', 'Times New Roman')
    font.setAttribute('underline', 'false')
  p = re.compile('^((\\.\\.|==|=|--|-)?[012345](\\.\\.|==|=|--|-)?|\\([012345]\\)|\\[[012345]\\])$')
  q = re.compile('^\(([pima]|ch|q)\)|[pima]|ch|q$')
  # mehrzeilige Fingersätze
  r = re.compile('^(\s*[012345]\s*\n\s*)+[012345]$')
  
  # fingering minimum for comp font size
  sizes = {}
  for text in score.getElementsByTagName('text'):
    content = getElement(text, 'content')
    if content and content.lastChild != None:
      if latin1_e(content.lastChild.nodeValue) in list('012345'):
        size = int(getElement(text, 'font').getAttribute('height'))
        if size in sizes:
          sizes[size] += 1
        else:
          sizes[size] = 1
  min_comp_size = 15
  for size in sizes:
    if size > min_comp_size and sizes[size] > 2:
      min_comp_size = size
  # mark fingering
  for voices in score.getElementsByTagName('voices'):
    voice_nr = 0
    for voice in voices.getElementsByTagName('voice'):
      voice_nr += 1
      for event_type in ['chord', 'rest']:
        color = '0000FE'
        pima_color = '00FF00' # light-green wird abgefragt für (p) = pima und nicht piano
        if voice_nr > 1:
          color = 'FE00FE'
          pima_color = '808000'
        if event_type == 'rest':
          color = errorColor
          pima_color = errorColor
        for chord in voice.getElementsByTagName(event_type):
          for text in chord.getElementsByTagName('text'):
            content = getElement(text, 'content')
            if content and content.lastChild != None:
              ttext = latin1_e(content.lastChild.nodeValue)
              font = getElement(text, 'font')
              if (p.match(ttext) or r.match(ttext)) and int(font.getAttribute('height')) <= min_comp_size:
                setFont(font, bold=True)
                _set_attribute(font, color)
                if len(ttext) == 1:
                  text.setAttribute('x', '-1.0')
                elif len(ttext) == 2:
                  text.setAttribute('x', '-2.0')
                elif '\n' in ttext:
                  text.setAttribute('x', '-1.0')
                else:
                  text.setAttribute('x', '-3.0')
                y = float(text.getAttribute('y'))
                text.setAttribute('y', "%f" % (round(y * 2) / 2))
              if q.match(ttext) and (font.getAttribute('face') != 'capella3'):
                setFont(font, bold=True)
                _set_attribute(font, pima_color)
                text.setAttribute('x', '0.0')
                y = float(text.getAttribute('y'))
                text.setAttribute('y', "%f" % (round(y * 2) / 2))
              if q.match(ttext) and (font.getAttribute('face') == 'capella3') and (float(text.getAttribute('y')) < 0):
                setFont(font, bold=True)
                _set_attribute(font, pima_color)
                text.setAttribute('x', '0.0')
                y = float(text.getAttribute('y'))
                text.setAttribute('y', "%f" % (round(y * 2) / 2))
                font.setAttribute('charSet', '1')
                content.lastChild.nodeValue = latin1_e("p")


# Lagen blau färben und Größe anpassen
# Dazu können Barrée-Angaben und/oder Weitergeltungslinien gehören
def guitar_mark_positions(score):
  def _set_attribute(font, color):
    setFont(font, bold=True)
    font.setAttribute('color', color)
    font.setAttribute('height', '15')
    font.setAttribute('face', 'Times New Roman')
    font.setAttribute('underline', 'false')
  p = re.compile(r'^-?((\[?C|\[?c|\[?B|\[?/C|\[?/c|\[?/B|1/2|1/2B|1/2C|PB|MC|MB|\[)\.?)?(I|II|III|IV|V|VI|VII|VIII|IX|X|XI|XII|XIII)(\.\.|--)?$')
  q = re.compile(r'^-?((C|c|B|/C|/c|/B|1/2|1/2B|1/2C|PB|MC|MB|\[)\.?)(\.\.|--)?$')
  for text in score.getElementsByTagName('text'):
    content = getElement(text, 'content')
    if content and content.lastChild != None:
      ttext = latin1_e(content.lastChild.nodeValue)
      if (ttext.lower() in ['c','c7','b','b7']):
        continue
      font = getElement(text, 'font')
      if font.getAttribute('face') != 'capella3':# and font.getAttribute('color') not in harmonyColors:
        if p.match(ttext) or q.match(ttext):
          _set_attribute(font, '0000FE')
          text.setAttribute('x', '0.0')
        if ttext == ']':
          _set_attribute(font, '0000FE')
          text.setAttribute('x', '2.0')
          text.setAttribute('y', '-2.0')

# Saiten/Lagenangaben an Pausen rot färben
def guitar_mark_words_rests(score):
  p = re.compile(r'^([sS][1234567](\.\.|--)?)$')
  q = re.compile(r'^-?((C|c|B|/C|/c|/B|1/2|1/2B|1/2C|PB|MC|MB|\[).?)?(I|II|III|IV|V|VI|VII|VIII|IX|X|XI|XII)(\.\.|--)?$')
  r = re.compile(r'^-?((C|c|B|/C|/c|/B|1/2|1/2B|1/2C|PB|MC|MB|\[).?)(\.\.|--)?$')
  s = re.compile(r'^(p|i|m|a|ch)$')
  for rest in score.getElementsByTagName('rest'):
    for text in rest.getElementsByTagName('text'):
      content = getElement(text, 'content')
      if content and content.lastChild != None:
        ttext = latin1_e(content.lastChild.nodeValue)
        if (ttext.lower() in ['c','c7','b','b7']):
          continue
        font = getElement(text, 'font')
        if font.getAttribute('face') != 'capella3' and \
           (p.match(ttext) or q.match(ttext) or r.match(ttext) or s.match(ttext) or ttext == ']'):
          # score.messageBox('guitar_mark_words_rests', ttext)
          font.setAttribute('color', errorColor)

def guitar_mark_glissandi(score):
  # In Akkorden in Linien ausrichten
  for chord in score.getElementsByTagName('chord'):
    for drawObj in chord.getElementsByTagName('drawObj'):
      noteRange = '0'
      for basic in drawObj.getElementsByTagName('basic'):
        noteRange = basic.getAttribute('noteRange')
      for line in drawObj.getElementsByTagName('line'):
        line.setAttribute('color', '0000FE')
        line.setAttribute('lineWidth', '0.2')
        if noteRange == '0': # Versuche Position der Linie zu bestimmen und danach auszurichten
          x1 = float(line.getAttribute('x1'))
          x2 = float(line.getAttribute('x2'))
          x = (x1+x2) / 2
          if x < 0:
            line.setAttribute('x1', '-1.5')
            line.setAttribute('x2', '0.2')
            y2 = float(line.getAttribute('y2'))
            line.setAttribute('y1', "%f" % (round(y2 * 2) / 2))
            line.setAttribute('y2', "%f" % (round(y2 * 2) / 2))
          else:
            line.setAttribute('x1', '0.5')
            line.setAttribute('x2', '2.2')
            y1 = float(line.getAttribute('y1'))
            line.setAttribute('y1', "%f" % (round(y1 * 2) / 2))
            line.setAttribute('y2', "%f" % (round(y1 * 2) / 2))
        # Range > 0 => echtes Glissando zwischen zwei Noten
        else:
          x1 = float(line.getAttribute('x1'))
          x2 = float(line.getAttribute('x2'))
          x = (x1+x2) / 2
          if x < 0:
            line.setAttribute('x1', '-1.5')
            line.setAttribute('x2', '0.2')
          else:
            line.setAttribute('x1', '1.0')
            line.setAttribute('x2', '2.0')
          y1 = float(line.getAttribute('y1'))
          line.setAttribute('y1', "%f" % (round(y1 * 2) / 2))
          y2 = float(line.getAttribute('y2'))
          line.setAttribute('y2', "%f" % (round(y2 * 2) / 2))
  for rest in score.getElementsByTagName('rest'):
    for line in rest.getElementsByTagName('line'):
      line.setAttribute('color', errorColor)
      line.setAttribute('lineWidth', '0.3')  



def optimize_guitar(score):
  plucking_mark_strings(score) # vor dem Einfärben der zweiten Stimme!!!
  guitar_fingering(score)
  guitar_mark_positions(score)
  guitar_mark_glissandi(score)
  guitar_mark_words_rests(score)
  repair(score)


def run_for_guitar(score):
  for staff in score.getElementsByTagName('staff'):
    rfg = False
    if staff.getAttribute('layout').startswith('Git'):
      rfg = True
    for content in staff.getElementsByTagName('content'):
      if latin1_e(content.lastChild.nodeValue) == '{GUITAR}':
        rfg = True
    if rfg:
      optimize_guitar(staff)
 
def set_keyword(score, keyword):
  doc = score.parentNode
  for info in score.getElementsByTagName('info'):
    keywords = getElement(info, 'keywords')
    if keywords:
      ttext = latin1_e(keywords.lastChild.nodeValue)
      if keyword in re.split('[,;:]', ttext):
        pass
      else:
        keywords.lastChild.nodeValue = latin1_e(ttext+':'+keyword)
    else:
      keywords = createNewChild(info, 'keywords')
      keywords.appendChild(doc.createTextNode(latin1_d(keyword)))

def general_optimize(score, files):
  remove_xplet_slurs(score) # nur einmal beim ersten Aufruf des Optimizers
  de_color(score)
  rtf_to_texts(score, files)
  shortcut_commands(score)
  basso_continuo_to_lyrics(score)
  erronous_words(score) # muss vor der Markierung von Gitarrenzeichen stehen
  optimize_lyrics(score)
  green_chords(score)
  pink_cues(score)
  pink_post_graces(score)
  colored_slurs(score)
  grace_slurs(score)
  slurs(score)  # Bindebögen der Länge 0, auf Pausen usw !!!
  repair_ties(score) # Haltebögen die in anderer Stimme enden unterdrücken
  ties_to_slurs(score)
  second_voice(score) # In der zweiten Stimme Winkel und Worteinschübe markieren
  second_pitch(score) # Ein Pitch steht innerhalb eines Akkords doppelt
  mark_pedal(score)
  grace_accidentals(score)
  solo_tutti(score)
  k_to_arpeggio(score)
  titles_etc(score)
  commands(score)
  tuplet_brackets(score)
  if first_call(score):
    extra_distance(score)
  check_alternation(score)
  word_min_size(score)
  assignments(score)
  optimize_chords(score, files)
  normal_sized_graces(score)
  rare_type_graces(score)
  blue_accidental(score)
  wedge_hints(score) # gesang und anfang stark verschobn => rot um auf zweite Stimme zu verweisen
  rectangle_hints(score)
  #grouping_separation(score)
  barlines(score) # Taktstriche wie :|| am Anfang und ||: am Ende der Zeile markieren
  beats_keys_errors(score)
  beats_rests_errors(score)
  check_arpeggio(score)
  mediaspecific_dynamics(score) # b:p etc.
  basso_continuo(score)
  lyrics_artificial_dynamics(score)
  landscape(score)
  staccato_to_articulation(score)
  clefs(score)
  rhythm_hints(score)
  special_words(score)
  run_for_guitar(score)
  if first_call(score):
    page_size(score)
    rests_texts(score)
    show_barnumbers(score)

def optimize_string(score):
  string_fingering(score)
  string_mark_positions(score)
  string_mark_strings(score)
  string_mark_rests(score)
  #basso_continuo(score) # general_optimize???
  repair(score)

def optimize_wind(score):
  repair(score)