# -*- coding: utf-8 -*-
""" capellaScript -- Matthias Leopold
>>> CyanTool

    Löscht die Cyan-Farbmarkierungen von unsichtbaren Pausen.
    Im Parallelsystem werden blaue Pausen unsichtbar gemacht und die Farbmarkierung von den Noten entfernt.
    
    Remove the cyan color markings from invisible pauses.
    In the parallel system, blue rests are made invisible and notes are decolored.

<<<
"""

from caplib.capDOM import ScoreChange
import os, re, string, sys, tempfile
sys.path.append(os.path.join(getPersonalDataDir(), 'scripts', 'user-scripts'))
import Optimizer

def debug(text='Text'):
    label = Label(text)
    box = VBox([label],padding=1)
    dlg = Dialog('Debugger', box)
    if dlg.run():
        return True
    else:
        return False

def getElements(parent, children):
  result = []
  for node in parent.childNodes:
    if node.nodeType == parent.ELEMENT_NODE and node.tagName in children:
      result.append(node)
  return result

light_cyan_colors = ['00FFFF', '00AAFF', '55FFFF', '55AAFF']
dark_cyan_colors = ['008B8B', '008080']
cyan_colors = light_cyan_colors+dark_cyan_colors

blue_colors = ['0000FF', '0055FF']

def _is_cyan(event):
  display = event.getElementsByTagName('display')
  if len(display) and display[0].getAttribute('color') in cyan_colors:
    return True
  return False

def _is_cyan_rest(event):
  return event != None and event.nodeName == 'rest' and _is_cyan(event)

def _is_cyan_chord(event):
  return event != None and event.nodeName == 'chord' and _is_cyan(event)

def _containing_cyan_color(staff):
  for event in staff.getElementsByTagName('rest') + staff.getElementsByTagName('chord'):
    if _is_cyan(event):
      return True
  return False



# Gefärbte Pausen unsichtbar machen wenn drumherum türkise Noten stehen
def _decolor_invisible_rests(staff):
  for voice in staff.getElementsByTagName('voice'):
    for noteObjects in voice.getElementsByTagName('noteObjects'):
      events = getElements(noteObjects, ['rest', 'chord'])
      i = 0
      while i < len(events):
        event0 = events[i-1] if i > 1 else None
        event1 = events[i]
        event2 = events[i+1] if i+1 < len(events) else None
        if _is_cyan_rest(event1) and (_is_cyan_chord(event0) or _is_cyan_chord(event2)):
          display = event1.getElementsByTagName('display')[0]
          display.setAttribute('invisible', 'true')
          display.setAttribute('color', '00FFFF')
        i += 1
      # Farben normalisieren
      i = 0
      while i < len(events):
        event1 = events[i]
        if _is_cyan_chord(event1):
          display = event1.getElementsByTagName('display')[0]
          if display.getAttribute('color') in dark_cyan_colors:
            display.setAttribute('color', '008080')
          else:
            display.setAttribute('color', '00FFFF')  
        i += 1
    
    
def _make_rests_invisible(staff):
  for voice in staff.getElementsByTagName('voice'):
    for noteObjects in voice.getElementsByTagName('noteObjects'):
      events = getElements(noteObjects, ['rest', 'chord'])
      i = 0
      while i < len(events):
        event1 = events[i]
        displays = event1.getElementsByTagName('display')
        if len(displays):
          display = displays[0]
          if display.getAttribute('color') in blue_colors:
            if event1.nodeName == 'rest':
              display.setAttribute('invisible', 'true')
            display.setAttribute('color', '000000')
        i += 1

def cyan_tool(score):
  for system in score.getElementsByTagName('system'):
    staffs = system.getElementsByTagName('staff')
    if len(staffs) < 2:
      continue
    if _containing_cyan_color(staffs[-1]):
      _decolor_invisible_rests(staffs[-1])
      _make_rests_invisible(staffs[-2])
    elif _containing_cyan_color(staffs[-2]):
      _decolor_invisible_rests(staffs[-2])
      _make_rests_invisible(staffs[-1])

class ScoreChange(ScoreChange):
  def changeScore(self, score):
    global doc  # Referenz auf das Dokument
    doc = score.parentNode
    cyan_tool(score)


if activeScore():
  activeScore().registerUndo("CapScan-Fehlersuche")
  tempInput = tempfile.mktemp('.capx')
  tempOutput = tempfile.mktemp('.capx')

  activeScore().write(tempInput)

  ScoreChange(tempInput, tempOutput)
  
  activeScore().read(tempOutput)
  os.remove(tempInput)
  os.remove(tempOutput)

