# -*- coding: utf-8 -*-
""" capellaScript -- Matthias Leopold
>>> DeCommand

    Befehle entfernen
    Remove commands
    
<<<
"""

from caplib.capDOM import ScoreChange
import os, re, string, sys, tempfile
sys.path.append(os.path.join(getPersonalDataDir(), 'scripts', 'user-scripts'))
import Optimizer

from Tools import latin1_e
from Tools import latin1_d

def debug(text='Text'):
    label = Label(text)
    box = VBox([label],padding=1)
    dlg = Dialog('Debugger', box)
    if dlg.run():
        return True
    else:
        return False

command_remove_regex = re.compile('^\s*\{\s*(S|M|P|SS|SP|SV|ACCORDION|PLUCKING)\s*\}\s*$')
command_remove2_regex = re.compile('^\s*\{\s*(S|M|P|SS|SP|SV)\s*:\s*\d+\s*\}\s*$')
command_remove3_regex = re.compile('^\s*\{\s*\W\s*\}\s*$')

command_2_regex = re.compile('^\s*\{\s*[A-Z]+:(.*?)\s*\}\s*$')
command_1_regex = re.compile('^\s*\{\s*(.*?)\s*\}\s*$')

def de_command(score):
  for text in score.getElementsByTagName('text'):
    for content in text.getElementsByTagName('content'):
      dtext = latin1_e(content.lastChild.nodeValue)
      dtext = command_remove_regex.sub('', dtext)
      dtext = command_remove2_regex.sub('', dtext)
      dtext = command_remove3_regex.sub('', dtext)
      dtext = command_2_regex.sub(r'\1', dtext)
      dtext = command_1_regex.sub(r'\1', dtext)
      content.lastChild.nodeValue = latin1_d(dtext)

class ScoreChange(ScoreChange):
  def changeScore(self, score):
    global doc  # Referenz auf das Dokument
    doc = score.parentNode
    Optimizer.de_color(score)
    de_command(score)


if activeScore():
  activeScore().registerUndo("CapScan-Fehlersuche")
  tempInput = tempfile.mktemp('.capx')
  tempOutput = tempfile.mktemp('.capx')

  activeScore().write(tempInput)

  ScoreChange(tempInput, tempOutput)
  
  activeScore().read(tempOutput)
  os.remove(tempInput)
  os.remove(tempOutput)

