# -*- coding: utf-8 -*-
""" capellaScript 
>>> LyricsOptimizer
    Suchen und Ersetzen auf Liedtexten

<<<

"""

from caplib.capDOM import ScoreChange
import xml.dom
from xml.dom.minidom import NodeList
import os, re, string, sys
sys.path.append(os.path.join(getPersonalDataDir(), 'scripts', 'user-scripts'))
import Tools
from Tools import latin1_e
from Tools import latin1_d
from Tools import createNewChild
from Tools import getElement




def getDialogValues():
  global SuchenText, ErsetzenText, wholeWord, binding
  SuchenTextEdit = Edit('', width= 20)
  ErsetzenTextEdit = Edit('', width= 20)
  SuchenTextLabel = Label('Ersetze:  ', width = 6)
  ErsetzenTextLabel = Label('durch: ', width = 6)
  wholeWordCheck = CheckBox('Ganzes Wort', value=1)
  bindingCheck = CheckBox('Silbenbindung', value=0)

  hbox1 = HBox([SuchenTextLabel, SuchenTextEdit], padding= 4)
  hbox2 = HBox([ErsetzenTextLabel, ErsetzenTextEdit], padding= 4)

  vbox  = VBox([hbox1, hbox2, wholeWordCheck, bindingCheck], text='', padding=4)
  dlg = Dialog('Liedtext korrigieren: ', vbox)

  if dlg.run():
    SuchenText = SuchenTextEdit.value()
    ErsetzenText = ErsetzenTextEdit.value()
    wholeWord = wholeWordCheck.value()
    binding = bindingCheck.value()
    if ErsetzenText[-1] == '-':
      binding = 1
      ErsetzenText = ErsetzenText.rstrip('-')
    return True
  else:
    return False



def replaceText(text, search, replace):
  if wholeWord == 0:
    p = re.compile(search)
    return p.sub(replace, text)
  else:
    p = re.compile(r'\b'+search+r'\b')
    return p.sub(replace, text)

# Prüft, ob der Text text auf ending endet
def ending(text, ending):
  p = re.compile(ending+r'$')
  if p.search(text):
    return True
  return False

def changeDoc2(score):
  global SuchenText, ErsetzenText
  if SuchenText == '':
    return
  for chord in score.getElementsByTagName('chord'):
    for lyric in chord.getElementsByTagName('lyric'):
      for verse in lyric.getElementsByTagName('verse'):
        try:
          lyricContent = latin1_e(verse.lastChild.nodeValue)
          newLyricContent = replaceText(lyricContent, SuchenText, ErsetzenText)
          change = False
          if newLyricContent != lyricContent:
            verse.removeChild(verse.lastChild)
            textNode2 = doc.createTextNode(latin1_d(newLyricContent))
            verse.appendChild(textNode2)
            change = True
          if lyricContent == SuchenText and lyricContent == ErsetzenText:
            if binding == 0 and verse.getAttribute('hyphen') == 'true':
              change = True
            if binding == 1 and verse.getAttribute('hyphen') != 'true':
              change = True
          if change:
            display = getElement(chord, 'display')
            if not display:
              display = createNewChild(chord, 'display')
            display.setAttribute('color', '00FE00')
          if change and ending(lyricContent, SuchenText):
            if binding == 1:
              verse.setAttribute('hyphen', 'true')
            else:
              verse.setAttribute('hyphen', 'false')
        except:
          pass



# Hauptprogramm:

from caplib.capDOM import ScoreChange
import tempfile

class ScoreChange(ScoreChange):
  def changeScore(self, score):
    Tools.init_doc(score.parentNode)
    changeDoc2(score)

class ScoreRestore(ScoreChange):
  def changeScore(self, score):
    global doc
    doc = score.parentNode


if activeScore():
  if getDialogValues():
    Tools.init_doc(score.parentNode)
    doc = activeScore()
    doc.registerUndo("Suchen und Ersetzen")
    tempInput = tempfile.mktemp('.capx')
    tempOutput = tempfile.mktemp('.capx')
    activeScore().write(tempInput)
    ScoreChange(tempInput, tempOutput)
    activeScore().read(tempOutput)
    os.remove(tempInput)
    os.remove(tempOutput)

    checkCapVersion(5, 1, 5)

    tempInput = tempfile.mktemp('.capx')
    tempOutput = tempfile.mktemp('.capx')
    activeScore().write(tempInput)
    ScoreRestore(tempInput, tempOutput)
    activeScore().read(tempOutput)
    os.remove(tempInput)
    os.remove(tempOutput)

