# -*- coding: utf-8 -*-
""" capellaScript -- Matthias Leopold
>>> CapScanOptimizer

    Verschiedene mögliche Fehler und Hinweise werden durch Farben angezeigt.

    Die Farben werden in den Arbeitsunterlagen unter OptimizerHilfe erklärt.

<<<

History: 03.04.06 - Liedtexte, Akkordsymbole


"""

import xml.dom.minidom
from caplib.capDOM import ScoreChange
import os, re, string, sys, tempfile, zipfile
sys.path.append(os.path.join(getPersonalDataDir(), 'scripts', 'user-scripts'))
import Optimizer, Tools

from Optimizer import set_chord_rest_color

from Tools import latin1_e
from Tools import latin1_d
from Tools import errorColor
from Tools import hintColor
from Tools import errorColor2

from Tools import cypherFont
from Tools import textFont

makebraille_dir = os.path.join(os.environ['APPDATA'], 'MakeBraille')
if not os.path.isdir(makebraille_dir):
  os.mkdir(makebraille_dir)

#sys.path.append(os.path.normpath('Z:\Leibnixml\lcore'))
#from lsys.lhunspell import get_hunspell
#from lsys.lhunspell import hunspell_exists

def reversed(list):
  newlist = []
  for x in list:
    newlist.insert(0, x)
  return newlist

def debug(text='Text'):
  labels = [Label(t+'   ') for t in text.strip().split('\n')]
  box = VBox(labels,padding=1)
  dlg = Dialog('Debugger', box)
  if dlg.run():
    return True
  else:
    return False

def createNewChild(el, name, new=False):
  if new:
    newEl = doc.createElement(name)
    el.appendChild(newEl)
  else:
    newEl = el.getElementsByTagName(name)
    if newEl.length == 0:
      newEl = doc.createElement(name)
      el.appendChild(newEl)
    else:
      newEl = newEl[0]
  return newEl


def createNewChildBefore(el, name, new=False):
  if new:
    newEl = doc.createElement(name)
    el.insertBefore(newEl, el.firstChild)
  else:
    newEl = el.getElementsByTagName(name)
    if newEl.length == 0:
      newEl = doc.createElement(name)
      el.insertBefore(newEl, el.firstChild)
    else:
      newEl = newEl[0]
  return newEl

def getElement(parent, *children):
     """ liefert Kind/Enkel/Urenkel..., z.B. parent.child0.child1.child2... """
     p = parent
     for c in children:
         found = 0
         for n in p.childNodes:
             if n.nodeType == parent.ELEMENT_NODE and n.tagName == c:
                 p = n
                 found = 1
                 break
         if not found: return 0
     return p

# Liefert angegebene direkte Kindknoten zurück
# so liefert z.B. getElements(staff, 'chord', 'rest') alle Notenobjekte eines staffs
def getElements(parent, children):
  result = []
  for node in parent.childNodes:
    if node.nodeType == parent.ELEMENT_NODE and latin1_e(node.tagName) in children:
      result.append(node)
  return result


# Prüft, ob es mehr Systeme im Mustersystem gibt, als irgendwann angezeigt werden
# Wenn ja -> Fehlermeldung
def system_check(score):
  global doc  # Referenz auf das Dokument
  doc = score.parentNode
  layout_systems = 0
  max_systems = 0
  for staffLayout in score.getElementsByTagName('staffLayout'):
    layout_systems += 1
  for system in score.getElementsByTagName('system'):
    current_systems = 0
    for staff in system.getElementsByTagName('staff'):
      current_systems += 1
    if current_systems > max_systems:
      max_systems = current_systems
  if max_systems < layout_systems :
    debug('Vermutlich Fehler im Mustersystem!!!')


# Fingersätze blau färben und in der Größe anpassen
def blue_fingering(score):
  # Wechselfingersätze
  q = re.compile('^([|]?[12345]([-|]?[12345])*[|]?|\\([12345]([-|]?[12345])*\\)|\\[[12345]([-|]?[12345])*\\])(\\n([|][12345]([-|]?[12345])*|\\([12345]([-|]?[12345])*\\)|\\[[12345]([-|]?[12345])*\\]))*$')
  # Auslassungsfingersätze (vertikal) 4\n_\n1
  r1 = re.compile('^(\[[12345]\]|\([12345]\)|[|]?[12345]([-|]?[12345])*|_)(\\n(\[[12345]\]|\([12345]\)|[|]?[12345]([-|]?[12345])*|_))*$')
  # Auslassungsfingersätze (horizontal) _-4
  r2 = re.compile('^_-[12345]')
  s = re.compile('[|]?[12345]') # keinerlei Fingersatz
  t = re.compile('^(\\(?[12345]( [12345])+\\)?)$') # Fingersätze mit Leerzeichen
  
  # Der überwiegende Anteil an Fingersätzen in der Zeile ist im 5-Linien-System => Fingersätze links versetzt positionieren  
  finger_count = 0
  finger_in_lines_count = 0
  for text in score.getElementsByTagName('text'):
    content = getElement(text, 'content')
    if content and not(content.lastChild is None):
      ttext = latin1_e(content.lastChild.nodeValue)
      if (q.match(ttext) or r1.match(ttext) or r2.match(ttext) or t.match(ttext)) and s.search(ttext):
        finger_count += 1
        if float(text.getAttribute('y')) > -2 and float(text.getAttribute('y')) < 2.5:
          finger_in_lines_count += 1
  if finger_in_lines_count*3 > finger_count:
    xOffset = '-1.5'
  else:
    xOffset = '0.0'
  
  for event_type in ['chord', 'rest']:
    color = '0000FE'
    if event_type == 'rest':
      color = errorColor
    for chord in score.getElementsByTagName(event_type):
      for text in chord.getElementsByTagName('text'):
        content = getElement(text, 'content')
        if content and not(content.lastChild is None):
          ttext = latin1_e(content.lastChild.nodeValue)
          if (q.match(ttext) or r1.match(ttext) or r2.match(ttext) or t.match(ttext)) and s.search(ttext):
            font = getElement(text, 'font')
            font.setAttribute('color', color)
            font.setAttribute('height', '10')
            font.setAttribute('weight', '700')
            font.setAttribute('width', '0')
            font.setAttribute('italic', 'false')
            font.setAttribute('underline', 'false')
            font.setAttribute('face', cypherFont)
            font.setAttribute('pitchAndFamily', '0')
            # falls Akkordisch und Fingersätze in Notenzeile so Stück rechts
            # Müller 18/3/2 14:13
            if len(chord.getElementsByTagName('head')) > 1 and \
               float(text.getAttribute('y')) > -2 and \
               float(text.getAttribute('y')) < 2.5:
              text.setAttribute('x', '1.8')
              text.setAttribute('align', 'left')
            elif len(ttext) == 1:
              text.setAttribute('x', xOffset)
              text.setAttribute('align', 'left')
            else:
              text.setAttribute('x', '0.6')
              text.setAttribute('align', 'center')
            if t.match(ttext):
              font.setAttribute('color', errorColor)

  # Wenn es mehrere Stimmen im System gibt und zu viele Fingersätze an einer Note so rot einfärben
  for staff in score.getElementsByTagName('staff'):
    voices = staff.getElementsByTagName('voice')
    if len(voices) > 1:
      for voice in voices:
        for chord in voice.getElementsByTagName('chord'):
          heads = chord.getElementsByTagName('head')
          if len(heads) == 1:
            for text in chord.getElementsByTagName('text'):
              content = getElement(text, 'content')
              if content and not(content.lastChild is None):
                ttext = latin1_e(content.lastChild.nodeValue).strip()
                if '\n' in ttext and re.match(r'\d\n\d', ttext):
                  for font in text.getElementsByTagName('font'):
                    font.setAttribute('color', errorColor)

# Innerhalb von Liedtexten Bögen anfärben, die nicht auf einer Silbe anfangen
# oder nicht vor einer Silbe enden oder auf derem Weg andere Silben stehen
#
# Das Konzept funktioniert nicht, da auch Dreck in den Silben stehen kann
#
#def phrases(score):
#  for voice in score.getElementsByTagName('voice'):
#    lyrics = voice.getElementsByTagName('lyric')
#    if lyrics != []:
#      for noteObjects in voice.getElementsByTagName('noteObjects'):
#        events = getElements(noteObjects, ['rest', 'chord'])
#        event_index = 0
#        for event in events:
#          event_index += 1
#          if latin1_e(event.nodeName) == 'chord':
#            lyric = event.getElementsByTagName('lyric')
#            for drawObj in event.getElementsByTagName('drawObj'):
#              slur = getElement(drawObj, 'slur')
#              if slur and lyric == []:
#                slur.setAttribute('color', '0000FE')




# Bögen, Winkel, Texte usw. einfärben, die unter einem System
# mit Gesangsnoten liegen (da vermutlich falsche Zuordnung)
def assignment(score):
  tolerance = -1.5 # Diese Zahl weicht ab im Vergleich zu GuitarOptimizer
  # Zunächst alle Systeme feststellen, die geschweifte Klammern haben (= Klavier, hier gilt die Prüfung nicht) in Array speichern (index)
  curly_staff = []
  curly_staff_h = {}
  upmost_curly = []
  upmost_curly_h = {} # staff name von obersten Klavierzeilen
  for layout in score.getElementsByTagName('layout'):
    for stafflayout in layout.getElementsByTagName('staffLayout'):
      curly_staff.append('false')
    for brackets in layout.getElementsByTagName('brackets'):
      for bracket in brackets.getElementsByTagName('bracket'):
        if bracket.getAttribute('curly') == 'true':
          from_system = int(bracket.getAttribute('from'))
          to_system = int(bracket.getAttribute('to'))
          upmost_curly += [from_system]
          for i in range (from_system, to_system+1):
            curly_staff[i] = 'true'
    staff_i = -1
    for stafflayout in layout.getElementsByTagName('staffLayout'):
      staff_i += 1
      description = str(stafflayout.getAttribute('description'))
      if curly_staff[staff_i] == 'true': curly_staff_h[description] = 'true'
      else: curly_staff_h[description] = 'false'
      if staff_i in upmost_curly: upmost_curly_h[description] = 'true'
      else: upmost_curly_h[description] = 'false'
  for system in score.getElementsByTagName('system'):
    for staff in system.getElementsByTagName('staff'):
      description = str(staff.getAttribute('layout'))
      if curly_staff_h[description] == 'false': # Nur Systeme ohne geschweifte Klammern auswerten
        verses = staff.getElementsByTagName('verse')
        if verses != []:
          for voice in staff.getElementsByTagName('voice'):
            lyricsSettings = getElement(voice, 'lyricsSettings')
            if lyricsSettings:
              font = getElement(lyricsSettings, 'font')
              if font:
                if latin1_e(font.getAttribute('color')) == '993200':
                  continue
            for noteObjects in voice.getElementsByTagName('noteObjects'):
              events = getElements(noteObjects, ['rest', 'chord'])
              for event in events:
                for drawObj in event.getElementsByTagName('drawObj'):
                  for text in drawObj.getElementsByTagName('text'):
                    content = getElement(text, 'content')
                    if content and content.lastChild != None:
                      ttext = latin1_e(content.lastChild.nodeValue)
                    # Falls es offenbar Strophen sind, so nicht einfärben
                    y = latin1_e(text.getAttribute('y'))
                    if '\n' not in ttext and ttext[0] != '{' and float(y) > tolerance:
                      font = getElement(text, 'font')
                      font.setAttribute('color', errorColor)
                    if re.match(r'^(\d\.\s*)+$', ttext): # 1./2. was Liedtextnummerierung ist
                      font = getElement(text, 'font')
                      font.setAttribute('color', errorColor)
                  for wedge in drawObj.getElementsByTagName('wedge'):
                    if float(latin1_e(wedge.getAttribute('y1'))) > tolerance:
                      wedge.setAttribute('color', errorColor)
      elif curly_staff_h[description] == 'true' and upmost_curly_h[description] == 'false':
        for wedge in staff.getElementsByTagName('wedge'):
          if float(latin1_e(wedge.getAttribute('y1'))) < tolerance:
            wedge.setAttribute('color', hintColor)
        for text in staff.getElementsByTagName('text'):
          content = getElement(text, 'content')
          if content.lastChild is None:
            continue
          if float(latin1_e(text.getAttribute('y'))) > tolerance:
            continue
          dtext = latin1_e(content.lastChild.nodeValue)
          font = getElement(text, 'font')
          if font.getAttribute('face') == 'capella3' and \
              dtext in ['{', 'z', 's', '|', 'r', 'q', 'p', 'i', 'h', 'g', 'f', 'j']:
            font.setAttribute('color', hintColor)
          if dtext in ['rit.', 'dim.', 'cresc.', 'accel.', 'decresc.', 'cr.', 'decr.', 'calando']:
            font.setAttribute('color', hintColor)


            #
# Falls ein Akkord die Eigenschaft suppress, force oder parenth hat, so
# auf alle Noten verteilen
# funktioniert nicht so, wie es soll
def support_accidental(score):
  for chord in score.getElementsByTagName('chord'):
    force = 0
    suppress = 0
    parenth = 0
    for alter in chord.getElementsByTagName('alter'):
      if alter.getAttribute('display') == 'force':
        force = 1
      if alter.getAttribute('display') == 'suppress':
        suppress = 1
      if alter.getAttribute('display') == 'parenth':
        parenth = 1
    for alter in chord.getElementsByTagName('alter'):
      if force == 1:
        alter.setAttribute('display', 'force')
      if suppress == 1:
        alter.setAttribute('display', 'suppress')
      if parenth == 1:
        alter.setAttribute('display', 'parenth')


def create_hand_symbol(chord, symbol, y):
  drawObjects = createNewChild(chord, 'drawObjects')
  drawObj = createNewChild(drawObjects, 'drawObj', True)
  text = createNewChild(drawObj, 'text')
  text.setAttribute('x', '-2.0')
  text.setAttribute('y', y)
  font = createNewChild(text, 'font', True)
  font.setAttribute('face', textFont)
  font.setAttribute('height', '12')
  font.setAttribute('weight', '0')
  font.setAttribute('charSet', '1')
  font.setAttribute('pitchAndFamily', '0')
  content = createNewChild(text, 'content', True)
  content.appendChild(doc.createTextNode(latin1_d(symbol)))


# Noten einfärben, die im anderen System angezeigt werden
# Die Einfärbung muss konstant gehalten werden (rekonstruktion)
# Die Verschiebung selbst wird deaktiviert, dafür Handzeichen eingefügt
def intersystemal_shifts(score):
  global doc  # Referenz auf das Dokument
  doc = score.parentNode
  found = False
  for voice in score.getElementsByTagName('voice'):
    mode = '' # 'rh' oder 'lh' falls gerade linke Hand oder rechte Hand-Symbol gesetzt
    for chord in voice.getElementsByTagName('chord'):
      display = getElement(chord, 'display')
      if display and display.getAttribute('color') == '40CCFF':
        found = True
      if display and display.getAttribute('notationStaff') == 'down':
        found = True
        display.setAttribute('notationStaff', 'normal')
        display.setAttribute('color', '40CCFF')
        if mode == '':
          create_hand_symbol(chord, '{LH}', '-3.5')
          mode = 'lh'
      elif display and display.getAttribute('notationStaff') == 'up':
        found = True
        display.setAttribute('notationStaff', 'normal')
        display.setAttribute('color', '40CCFF')
        if mode == '':
          create_hand_symbol(chord, '{RH}', '-5')
          mode = 'rh'
      elif mode == 'lh':
        create_hand_symbol(chord, '{RH}', '-5')
        mode = ''
      elif mode == 'rh':
        create_hand_symbol(chord, '{LH}', '-3.5')
        mode = ''
    if found:
      for beam in voice.getElementsByTagName('beam'):
        beam.setAttribute('gradient', '0')
        beam.setAttribute('shift', '0')

def print_texts(score):
  for text in score.getElementsByTagName('text'):
    content = text.getElementsByTagName('content')[0]
    if content.lastChild is None:
      continue
    debug('next tag')
    #debug(type(content.lastChild.nodeValue))
    dtext = latin1_e(content.lastChild.nodeValue)
    debug(dtext)

    
def spell_checker(score):
  lyric = {}
  chords = {}
  if hunspell_exists('de'):
    debug('hallo')
  de_hunspell = get_hunspell('de')
  for system in score.getElementsByTagName('system'):
    staff_i = 0
    for staff in system.getElementsByTagName('staff'):
      staff_i += 1
      voice_i = 0
      for voice in staff.getElementsByTagName('voice'):
        voice_i += 1
        for chord in voice.getElementsByTagName('chord'):
          for verse in chord.getElementsByTagName('verse'):
            verse_i = latin1_e(verse.getAttribute('i'))
            has_hyphen = verse.getAttribute('hyphen') == 'true'
            if verse.lastChild != None:
              dtext = latin1_e(verse.lastChild.nodeValue)
              if verse_i not in lyric or lyric[verse_i] == None:
                chords[verse_i] = chord
                lyric[verse_i] = dtext
              else:
                lyric[verse_i] += dtext
              if not has_hyphen:
                debug(lyric[verse_i])
                # Falls Prüfung scheitert
                set_chord_rest_color(chords[verse_i], errorColor)
                lyric[verse_i] = None

files = {}

class ScoreChange(ScoreChange):
  def changeScore(self, score):
    score.messageBox = lambda title,msg: messageBox(title, msg)
    Tools.init_doc(score.parentNode)
    Optimizer.repair(score)
    Optimizer.repair_brackets(score)
    system_check(score)
    Optimizer.general_optimize(score, files)
    blue_fingering(score)
    assignment(score)
    #support_accidental(score) # ist fehlerhaft
    intersystemal_shifts(score)
    Optimizer.repair(score)
    #spell_checker(score) TODO activate with 2.3!!!
    #print_texts(score)
    Optimizer.set_keyword(score, 'CapScanOptimizer')
    debug('\n'.join(Optimizer.messages)+'\nReady!')
  def __init__(self, inputFile, outputFile=''):
    if outputFile == '':
      #outputFile = inputFile[:-5] + '~.capx'
      outputFile = inputFile[:inputFile.rfind('.')] + '~.capx'
    zr = zipfile.ZipFile(inputFile, 'r')
    zw = zipfile.ZipFile(outputFile, 'w', zipfile.ZIP_DEFLATED)
    for name in zr.namelist():
      files[name] = zr.read(name)
    for name in zr.namelist():
      t = zr.read(name)
      if name == 'score.xml':
        self.doc = xml.dom.minidom.parseString(t)
        #--- Partitur ändern und in temporärer Datei speichern
        tempFile = tempfile.mktemp('.xml')
        self.f = file(tempFile, 'wt')
        self.f.write('<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>\n')
        self.changeScore(self.doc.documentElement)
        self.copyElement(self.doc.documentElement)
        self.f.close()
        zw.write(tempFile, 'score.xml')
        os.remove(tempFile)
      else:
        info = zipfile.ZipInfo(name)
        info.compress_type = zipfile.ZIP_DEFLATED
        zw.writestr(info, t)


if activeScore():
  activeScore().registerUndo("CapScan-Fehlersuche")
  tempInput = tempfile.mktemp('.capx')
  tempOutput = tempfile.mktemp('.capx')

  activeScore().write(tempInput)

  ScoreChange(tempInput, tempOutput)

  activeScore().read(tempOutput)
  os.remove(tempInput)
  os.remove(tempOutput)
 