# -*- coding: utf-8 -*-
""" capellaScript -- Matthias Leopold
>>> Phrases

    Bögen ab einer definierten Länge als Phrasierungsbögen (blau) markieren.

<<<

History: 23.03.18 - Liedtexte, Akkordsymbole


"""

import xml.dom.minidom
from caplib.capDOM import ScoreChange
import os, re, string, sys, tempfile, zipfile
sys.path.append(os.path.join(getPersonalDataDir(), 'scripts', 'user-scripts'))
from Tools import latin1_e
from Tools import latin1_d

import Tools

def debug(text='Text'):
  label = Label(text)
  box = VBox([label],padding=1)
  dlg = Dialog('Debugger', box)
  if dlg.run():
    return True
  else:
    return False

def get_minumum_range():
  label = Label('Range: ', width = 6)
  edit = Edit('', width=4)
  vbox  = VBox([label, edit], text='', padding=4)
  dlg = Dialog('Minimale Bogenlänge', vbox)
  solution = ''
  if dlg.run():
    solution = edit.value()
  return int(solution)


def getElement(parent, *children):
     """ liefert Kind/Enkel/Urenkel..., z.B. parent.child0.child1.child2... """
     p = parent
     for c in children:
         found = 0
         for n in p.childNodes:
             if n.nodeType == parent.ELEMENT_NODE and n.tagName == c:
                 p = n
                 found = 1
                 break
         if not found: return 0
     return p

# Liefert angegebene direkte Kindknoten zurück
# so liefert z.B. getElements(staff, 'chord', 'rest') alle Notenobjekte eines staffs
def getElements(parent, children):
  result = []
  for node in parent.childNodes:
    if node.nodeType == parent.ELEMENT_NODE and latin1_e(node.tagName) in children:
      result.append(node)
  return result


#
def phrases(score, minrange):
  for drawObj in score.getElementsByTagName('drawObj'):
    if getElement(drawObj, 'slur'):
      slur = getElement(drawObj, 'slur')
      basic = getElement(drawObj, 'basic')
      if basic and int(basic.getAttribute('noteRange')) >= minrange:
        slur.setAttribute('color', '0000FF')



files = {}

class ScoreChange(ScoreChange):
  def changeScore(self, score):
    Tools.init_doc(score.parentNode)
    min_range = get_minumum_range()
    phrases(score, min_range)
    debug('Ready!')
  def __init__(self, inputFile, outputFile=''):
    if outputFile == '':
      #outputFile = inputFile[:-5] + '~.capx'
      outputFile = inputFile[:inputFile.rfind('.')] + '~.capx'
    zr = zipfile.ZipFile(inputFile, 'r')
    zw = zipfile.ZipFile(outputFile, 'w', zipfile.ZIP_DEFLATED)
    for name in zr.namelist():
      files[name] = zr.read(name)
    for name in zr.namelist():
      t = zr.read(name)
      if name == 'score.xml':
        self.doc = xml.dom.minidom.parseString(t)
        #--- Partitur ändern und in temporärer Datei speichern
        tempFile = tempfile.mktemp('.xml')
        self.f = file(tempFile, 'wt')
        self.f.write('<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>\n')
        self.changeScore(self.doc.documentElement)
        self.copyElement(self.doc.documentElement)
        self.f.close()
        zw.write(tempFile, 'score.xml')
        os.remove(tempFile)
      else:
        info = zipfile.ZipInfo(name)
        info.compress_type = zipfile.ZIP_DEFLATED
        zw.writestr(info, t)


if activeScore():
  activeScore().registerUndo("CapScan-Fehlersuche")
  tempInput = tempfile.mktemp('.capx')
  tempOutput = tempfile.mktemp('.capx')

  activeScore().write(tempInput)

  ScoreChange(tempInput, tempOutput)

  activeScore().read(tempOutput)
  os.remove(tempInput)
  os.remove(tempOutput)
 