# -*- coding: utf-8 -*-
""" capellaScript -- Matthias Leopold
>>> ViolinOptimizer

    Verschiedene mögliche Fehler und Hinweise werden durch Farben angezeigt.
    
    Die Farben werden in den Arbeitsunterlagen unter OptimizerHilfe erklärt.

<<<



"""

import xml.dom.minidom
from caplib.capDOM import ScoreChange
import os, re, string, sys, tempfile, zipfile
sys.path.append(os.path.join(getPersonalDataDir(), 'scripts', 'user-scripts'))
import Optimizer, Tools

def debug(text='Text'):
  label = Label(text)
  box = VBox([label],padding=1)
  dlg = Dialog('Debugger', box)
  if dlg.run():
    return True
  else:
    return False

# Prüft, ob es mehr Systeme im Mustersystem gibt, als irgendwann angezeigt werden
# Wenn ja -> Fehlermeldung
def system_check(score):
  global doc  # Referenz auf das Dokument
  doc = score.parentNode
  layout_systems = 0
  max_systems = 0
  for staffLayout in score.getElementsByTagName('staffLayout'):
    layout_systems += 1
  for system in score.getElementsByTagName('system'):
    current_systems = 0
    for staff in system.getElementsByTagName('staff'):
      current_systems += 1
    if current_systems > max_systems:
      max_systems = current_systems
  if max_systems < layout_systems :
    debug('Vermutlich Fehler im Mustersystem!!!')

files = {}

class ScoreChange(ScoreChange):
  def changeScore(self, score):
    Tools.init_doc(score.parentNode)
    Optimizer.repair(score)
    Optimizer.repair_brackets(score)
    system_check(score)
    Optimizer.mark_violin(score)
    Optimizer.optimize_string(score, files)
    Optimizer.set_keyword(score, 'ViolinOptimizer')
    debug('Ready!')
  def __init__(self, inputFile, outputFile=''):
    if outputFile == '':
      #outputFile = inputFile[:-5] + '~.capx'
      outputFile = inputFile[:inputFile.rfind('.')] + '~.capx'
    zr = zipfile.ZipFile(inputFile, 'r')
    zw = zipfile.ZipFile(outputFile, 'w', zipfile.ZIP_DEFLATED)
    for name in zr.namelist():
      files[name] = zr.read(name)
    for name in zr.namelist():
      t = zr.read(name)
      if name == 'score.xml':
        self.doc = xml.dom.minidom.parseString(t)
        #--- Partitur ändern und in temporärer Datei speichern
        tempFile = tempfile.mktemp('.xml')
        self.f = file(tempFile, 'wt')
        self.f.write('<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>\n')
        self.changeScore(self.doc.documentElement)
        self.copyElement(self.doc.documentElement)
        self.f.close()
        zw.write(tempFile, 'score.xml')
        os.remove(tempFile)
      else:
        info = zipfile.ZipInfo(name)
        info.compress_type = zipfile.ZIP_DEFLATED
        zw.writestr(info, t)
    
if activeScore():
  activeScore().registerUndo('ViolinOptimizer')
  tempInput = tempfile.mktemp('.capx')
  tempOutput = tempfile.mktemp('.capx')

  activeScore().write(tempInput)
  ScoreChange(tempInput, tempOutput)
  
  activeScore().read(tempOutput)
  os.remove(tempInput)
  os.remove(tempOutput)
