# -*- coding: utf-8 -*-

errorColor = 'FE0000'
errorColor2 = 'DC8909'
errorShape = 'crossCircle2'
hintColor = 'FE00FE'
commandColor = '993200'
harmonyColor = '008000'
harmonyColors = [harmonyColor, '00AA00', '00AA7F', '55AA00', '55AA7F', '005500']

commandFont = 'Cambria'
cypherFont = 'Bodoni'
lyricsFont = 'Segoe UI' # Tahoma
bcFont = 'Cambria'
textFont = 'Times New Roman'
errorFont = 'Times New Roman'

doc = None
def init_doc(_doc):
  global doc
  assert doc == None
  doc = _doc
  assert doc != None

###############################################################################

def latin1_e(u):
  return u

def latin1_d(u):
  return u

###############################################################################

def setFont(font, bold=False, italic=False, type=None):
  if bold:
    font.setAttribute('weight', '700')
  else:
    font.setAttribute('weight', '200')
  if italic:
    font.setAttribute('italic', 'true')
  else:
    font.setAttribute('italic', 'false')
  font.setAttribute('width', '0')
  if type == 'chord':
    font.setAttribute('color', harmonyColor)
    font.setAttribute('height', '12')
    font.setAttribute('face', 'Verdana')
    font.setAttribute('underline', 'true')
  
###############################################################################

def createNewChild(el, name, new=False):
  global doc
  assert doc != None
  if new:
    newEl = doc.createElement(name)
    el.appendChild(newEl)
  else:
    newEl = el.getElementsByTagName(name)
    if newEl.length == 0:
      newEl = doc.createElement(name)
      el.appendChild(newEl)
    else:
      newEl = newEl[0]
  return newEl

###############################################################################

def createNewChildBefore(el, name, new=False):
  global doc
  assert doc != None
  if new:
    newEl = doc.createElement(name)
    el.insertBefore(newEl, el.firstChild)
  else:
    newEl = el.getElementsByTagName(name)
    if newEl.length == 0:
      newEl = doc.createElement(name)
      el.insertBefore(newEl, el.firstChild)
    else:
      newEl = newEl[0]
  return newEl

###############################################################################

def getElement(parent, *children):
  assert not isinstance(children, list)
  """ liefert Kind/Enkel/Urenkel..., z.B. parent.child0.child1.child2... """
  p = parent
  for c in children:
    found = 0
    for n in p.childNodes:
      if n.nodeType == parent.ELEMENT_NODE and n.tagName == c:
        p = n
        found = 1
        break
    if not found: return 0
  return p

###############################################################################

# events = getElements(noteObjects, ['rest', 'chord', 'barline'])

# Liefert angegebene direkte Kindknoten zurück
# so liefert z.B. getElements(staff, 'chord', 'rest') alle Notenobjekte eines staffs
def getElements(parent, children):
  assert isinstance(children, list)
  result = []
  for node in parent.childNodes:
    if node.nodeType == parent.ELEMENT_NODE and latin1_e(node.tagName) in children:
      result.append(node)
  return result

###############################################################################
 
def getText(node):
  allowed = ['verse', 'author', 'comment', 'content']
  assert node.tagName in allowed
  if node.tagName in allowed and node.hasChildNodes() and node.lastChild != None:
    return latin1_e(node.lastChild.nodeValue)
  else:
    return ''

def setText(node, text):
  if node.tagName in ['verse', 'content']:
    if len(text):
      if node.hasChildNodes() and node.lastChild != None:
        node.lastChild.nodeValue = latin1_d(text)
      else:
        assert not node.hasChildNodes()
        node.appendChild(doc.createTextNode(latin1_d(text)))
    else: # text == ''
      if node.hasChildNodes() and node.lastChild != None:
        node.lastChild.nodeValue = latin1_d('')
  else:
    assert False

###############################################################################

def stripMarks(text):
  marks = [' ', '.', ',', ':', '-', '_']
  while len(text) and text[0] in marks:
    text = text[1:]
  while len(text) and text[-1] in marks:
    text = text[:-1]
  return text

###############################################################################

def setAttributes(node, attrib):
  for k in attrib:
    node.setAttribute(k, str(attrib[k]))

###########

fromMusicXML_v = None

def fromMusicXML(score):
  global fromMusicXML_v
  if fromMusicXML_v == None:
    fromMusicXML_v = False
    for comment in score.getElementsByTagName('comment'):
      text = getText(comment)
      if 'musicxml' in text.lower():
        fromMusicXML_v = True
  return fromMusicXML_v

def isalpha(s):
  if len(s) == 0: return False
  for c in s:
    if c not in list(u'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZäöüÄÖÜßé'):
      return False
  return True